/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.test.db.support;

import cn.com.yusys.yusp.commons.test.db.Column;
import cn.com.yusys.yusp.commons.test.db.DatabasePrepare;
import cn.com.yusys.yusp.commons.test.db.Table;
import cn.com.yusys.yusp.commons.test.util.Strings;
import cn.com.yusys.yusp.commons.util.DataSourceUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import java.sql.JDBCType;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;

public class OraclePrepare
implements DatabasePrepare {
    private static final List<JDBCType> nonLengthType = ListUtils.newArrayList((Object[])new JDBCType[]{JDBCType.INTEGER, JDBCType.CLOB, JDBCType.BLOB});

    @Override
    public void createTable(DataSource dataSource, String tableName, String initTableSqlScript) throws Exception {
        String tableQuerySql = String.format("select count(*) from user_tables where table_name = '%s'", tableName);
        int totalTable = DataSourceUtils.executeQueryScript((DataSource)dataSource, (String)tableQuerySql);
        if (totalTable < 1) {
            DataSourceUtils.executeUpdateScript((DataSource)dataSource, (String)initTableSqlScript);
        }
    }

    @Override
    public String getCreateTableSql(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        builder.append(table.getName()).append("(");
        String column = table.getColumns().stream().map(OraclePrepare::convertColumn).reduce("", Strings.CONCAT, String::concat);
        builder.append(column).append(")");
        String keySql = OraclePrepare.getPrimaryKeySql(table);
        if (StringUtils.nonEmpty((CharSequence)keySql)) {
            builder.append(";").append(keySql).append(";");
        }
        return builder.toString();
    }

    private static String convertColumn(Column column) {
        StringBuilder builder = new StringBuilder();
        builder.append(column.getName()).append(" ");
        builder.append(column.getType().getName());
        switch (column.getType()) {
            case NUMERIC: {
                if (!Objects.nonNull(column.getLength())) break;
                builder.append("(").append(column.getLength());
                if (column.getDigit() > 0) {
                    builder.append(",").append(column.getDigit());
                }
                builder.append(")");
                break;
            }
            case VARCHAR: {
                builder.append("2").append("(").append(column.getLength()).append(")");
                break;
            }
            case INTEGER: {
                break;
            }
            case CLOB: {
                break;
            }
            case BLOB: {
                break;
            }
            case DECIMAL: {
                builder.append("(").append(column.getLength()).append(",").append(column.getDigit()).append(")");
                break;
            }
            default: {
                builder.append("(").append(column.getLength()).append(")");
            }
        }
        if (!column.isNull()) {
            builder.append(" NOT ");
        }
        builder.append(" NULL ");
        return builder.toString();
    }

    private static String getPrimaryKeySql(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ").append(table.getName()).append(" ADD PRIMARY KEY (");
        String keys = table.getColumns().stream().filter(Column::isPrimary).map(Column::getName).reduce("", Strings.CONCAT, String::concat);
        builder.append(keys).append(")");
        return StringUtils.nonEmpty((CharSequence)keys) ? builder.toString() : null;
    }
}

