/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.test.db;

import cn.com.yusys.yusp.commons.test.db.DatabasePrepare;
import cn.com.yusys.yusp.commons.test.db.Table;
import cn.com.yusys.yusp.commons.test.db.support.OraclePrepare;
import cn.com.yusys.yusp.commons.test.db.util.DataSourceUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.collection.KeyValue;
import cn.com.yusys.yusp.commons.util.collection.MapUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public final class DbFactory {
    private static final Map<String, Class<? extends DatabasePrepare>> registerPrepare = new ConcurrentHashMap<String, Class<? extends DatabasePrepare>>();
    private DatabasePrepare prepare;

    private DbFactory() {
    }

    public static DbFactory factory() {
        return DbFactoryHandle.FACTORY;
    }

    public void createTable(String tableName, String initTableSqlScript) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        this.prepare.createTable(dataSource, tableName, initTableSqlScript);
    }

    public void createTable(Table table) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        this.prepare.initTable(dataSource, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndInitDatabasePrepare(DataSource dataSource) {
        if (!Objects.isNull(this.prepare)) return;
        Class<DbFactory> clazz = DbFactory.class;
        synchronized (DbFactory.class) {
            if (!Objects.isNull(this.prepare)) return;
            String dialect = DataSourceUtils.getDialect(dataSource);
            Class<? extends DatabasePrepare> classes = registerPrepare.get(dialect);
            Asserts.nonNull(classes, (Object[])new Object[]{"\u5c1a\u672a\u5b9e\u73b0\u6570\u636e\u5e93\u4e3a{}\u7684\u521d\u59cb\u5316\u6570\u636e\u51c6\u5907\u7c7b", dialect});
            this.prepare = (DatabasePrepare)BeanUtils.newInstance(classes);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int count(String countSql) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        return this.prepare.count(dataSource, countSql);
    }

    public int update(String updateSql) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        return this.prepare.update(dataSource, updateSql);
    }

    public int delete(String deleteSql) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        return this.prepare.delete(dataSource, deleteSql);
    }

    public <T> List<T> selectList(String selectSql, Class<T> targetClass) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        return this.prepare.selectList(dataSource, selectSql, targetClass);
    }

    public <T> T selectOne(String selectSql, Class<T> targetClass) throws Exception {
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        return this.prepare.selectOne(dataSource, selectSql, targetClass);
    }

    public void dropTable(String tableName) throws Exception {
        Asserts.nonEmpty((CharSequence)tableName, (Object[])new Object[]{"Table name must not Empty!"});
        DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
        this.checkAndInitDatabasePrepare(dataSource);
        this.prepare.dropTable(dataSource, tableName);
    }

    static {
        registerPrepare.putAll(MapUtils.ofConcurrentHashMap((KeyValue[])new KeyValue[]{MapUtils.ofEntry((Object)"oracle", OraclePrepare.class)}));
    }

    private static final class DbFactoryHandle {
        private static final DbFactory FACTORY = new DbFactory();

        private DbFactoryHandle() {
        }
    }
}

