/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.test.db;

import cn.com.yusys.yusp.commons.test.db.Table;
import cn.com.yusys.yusp.commons.test.db.util.DataSourceUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import javax.sql.DataSource;

public interface DatabasePrepare {
    public void createTable(DataSource var1, String var2, String var3) throws Exception;

    default public void initTable(DataSource dataSource, Table table) throws Exception {
        Asserts.nonNull((Object)table, (Object[])new Object[]{"Init table information must not empty!"});
        this.createTable(dataSource, table.getName(), this.getCreateTableSql(table));
    }

    public String getCreateTableSql(Table var1);

    default public void dropTable(DataSource dataSource, String tableName) throws Exception {
        Asserts.nonEmpty((CharSequence)tableName, (Object[])new Object[]{"Table must not null!"});
        DataSourceUtils.executeUpdateScript(dataSource, StringUtils.builder0((Object[])new Object[]{"DROP TABLE ", tableName}));
    }

    default public int count(DataSource dataSource, String countSql) throws Exception {
        return DataSourceUtils.count(dataSource, countSql);
    }

    default public int update(DataSource dataSource, String updateSql) throws Exception {
        return DataSourceUtils.update(dataSource, updateSql);
    }

    default public int delete(DataSource dataSource, String deleteSql) throws Exception {
        return DataSourceUtils.delete(dataSource, deleteSql);
    }

    default public <T> List<T> selectList(DataSource dataSource, String selectSql, Class<T> targetClass) throws Exception {
        return DataSourceUtils.selectList(dataSource, selectSql, targetClass);
    }

    default public <T> T selectOne(DataSource dataSource, String selectSql, Class<T> targetClass) throws Exception {
        return DataSourceUtils.selectOne(dataSource, selectSql, targetClass);
    }
}

