/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.test.db;

import java.sql.JDBCType;

public class Column {
    private String name;
    private JDBCType type;
    private Integer length;
    private boolean isNull;
    private boolean isPrimary;
    private int digit;

    public Column() {
    }

    public Column(String name, JDBCType type, Integer length, boolean isNull, boolean isPrimary, int digit) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.isNull = isNull;
        this.isPrimary = isPrimary;
        this.digit = digit;
    }

    public static final Column ofVarcharPrimary(String name, Integer length) {
        return Column.ofPrimary(name, JDBCType.VARCHAR, length);
    }

    public static final Column ofCanNullVarchar(String name, Integer length) {
        return Column.of(name, JDBCType.VARCHAR, length, true, false, -1);
    }

    public static final Column ofPrimary(String name, JDBCType type, Integer length) {
        return Column.of(name, type, length, false, true, -1);
    }

    public static final Column ofCanNull(String name, JDBCType type, Integer length) {
        return Column.of(name, type, length, true, false, -1);
    }

    public static final Column of(String name, JDBCType type, Integer length, boolean isNull, boolean isPrimary, int digit) {
        return new Column(name, type, length, isNull, isPrimary, digit);
    }

    public String getName() {
        return this.name;
    }

    public JDBCType getType() {
        return this.type;
    }

    public Integer getLength() {
        return this.length;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public int getDigit() {
        return this.digit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(JDBCType type) {
        this.type = type;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public void setDigit(int digit) {
        this.digit = digit;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", type=" + this.getType() + ", length=" + this.getLength() + ", isNull=" + this.isNull() + ", isPrimary=" + this.isPrimary() + ", digit=" + this.getDigit() + ")";
    }
}

