/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.zuul.web.rest;

import io.swagger.annotations.Api;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9e\u4f8b\u5217\u8868"})
@RequestMapping
@RestController
public class ZuulSwaggerResources {
    private static final Logger log = LoggerFactory.getLogger(ZuulSwaggerResources.class);
    private DiscoveryClient discoveryClient;

    public ZuulSwaggerResources(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @GetMapping(value={"/api/routes/"})
    public List<ServiceInstance> findInstanceByServiceId(@RequestParam(required=false) String serviceId) {
        log.debug("fetch service :{} instance list", (Object)serviceId);
        if (StringUtils.isEmpty((String)serviceId)) {
            CopyOnWriteArrayList<ServiceInstance> allInstances = new CopyOnWriteArrayList<ServiceInstance>();
            this.discoveryClient.getServices().forEach(service -> allInstances.addAll(this.discoveryClient.getInstances(service)));
            return allInstances;
        }
        return this.discoveryClient.getInstances(serviceId);
    }
}

