/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.zuul;

import cn.com.yusys.yusp.commons.swagger.zuul.RouteDto;
import cn.com.yusys.yusp.commons.swagger.zuul.RoutesProvider;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import springfox.documentation.swagger.web.InMemorySwaggerResourcesProvider;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

public class ZuulSwaggerResourcesProvider
implements SwaggerResourcesProvider,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ZuulSwaggerResourcesProvider.class);
    private static Environment environment;
    private static final String APPLICATION_NAME_KEY = "spring.application.name";
    private RoutesProvider routesProvider;
    private InMemorySwaggerResourcesProvider memorySwaggerResourcesProvider;

    public ZuulSwaggerResourcesProvider(RoutesProvider routesProvider, InMemorySwaggerResourcesProvider memorySwaggerResourcesProvider) {
        this.routesProvider = routesProvider;
        this.memorySwaggerResourcesProvider = memorySwaggerResourcesProvider;
    }

    public List<SwaggerResource> get() {
        String applicationName;
        List resources = this.memorySwaggerResourcesProvider.get();
        if (environment != null && resources != null && resources.size() == 1 && StringUtils.nonEmpty((CharSequence)(applicationName = environment.getProperty(APPLICATION_NAME_KEY)))) {
            resources.forEach(resource -> {
                if (resource.getName().equals("default")) {
                    resource.setName(applicationName);
                }
            });
        }
        List<RouteDto> routes = this.routesProvider.getRoutes();
        log.debug("Route Size:{}", (Object)routes.size());
        resources = Optional.ofNullable(resources).orElseGet(LinkedList::new);
        for (RouteDto route : routes) {
            resources.add(this.swaggerResource(route.getId(), route.getPath().replace("**", "v2/api-docs")));
        }
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location) {
        log.debug("name:{},location:{}", (Object)name, (Object)location);
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }

    public void setEnvironment(Environment env) {
        environment = env;
    }
}

