/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.zuul;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.zuul.context.RequestContext;
import java.util.List;
import java.util.Optional;

public class ZuulHostPortPreferRule
implements IRule {
    private ILoadBalancer loadBalancer;
    private static final String INSTANCE_HEADER = "instance-prefer";

    public Server choose(Object key) {
        String hostPort = "";
        if (RequestContext.getCurrentContext() != null && RequestContext.getCurrentContext().getRequest() != null) {
            hostPort = RequestContext.getCurrentContext().getRequest().getHeader(INSTANCE_HEADER);
        }
        if (StringUtils.isEmpty((CharSequence)hostPort)) {
            return null;
        }
        List allServers = this.loadBalancer.getAllServers();
        String finalHostPort = hostPort;
        Optional<Server> optionalServer = allServers.stream().filter(server -> this.match((Server)server, key, finalHostPort)).findFirst();
        return optionalServer.orElse(null);
    }

    boolean match(Server server, Object key, String hostPort) {
        return StringUtils.equals((CharSequence)server.getHostPort(), (CharSequence)hostPort);
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        this.loadBalancer = lb;
    }

    public ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }
}

