/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.starter.config;

import cn.com.yusys.yusp.commons.starter.config.WebFilterProperties;
import cn.com.yusys.yusp.commons.starter.config.WebProperties;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.web.filter.AccessFilter;
import cn.com.yusys.yusp.commons.web.filter.XssAndSqlFilter;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ConditionalOnClass(value={Filter.class})
@EnableConfigurationProperties(value={WebProperties.class, WebFilterProperties.class})
public class WebFilterAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WebFilterAutoConfiguration.class);

    @Bean
    @ConditionalOnExpression(value="'true'.equals('${yusp.filter.xss.enabled:true}')")
    public FilterRegistrationBean<Filter> xssAndSqlFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new XssAndSqlFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        registration.setDispatcherTypes(dispatcherTypes);
        logger.info("Anti XSS attack SQL injection filter configuration completed");
        return registration;
    }

    @Configuration
    @ConditionalOnProperty(name={"yusp.filter.cors.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={CorsFilter.class})
    static class CorsAutoConfiguration {
        CorsAutoConfiguration() {
        }

        @Bean
        public FilterRegistrationBean<Filter> corsFilterBean(WebFilterProperties webFilterProperties) {
            WebFilterProperties.CorsConfiguration corsConfiguration = webFilterProperties.getCors();
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
            if (corsConfiguration.getAllowedOrigins() != null && !corsConfiguration.getAllowedOrigins().isEmpty() && CollectionUtils.nonEmpty(corsConfiguration.getPaths())) {
                corsConfiguration.getPaths().stream().map(StringUtils::trim).filter(StringUtils::nonBlank).forEach(path -> source.registerCorsConfiguration(path, (CorsConfiguration)corsConfiguration));
            }
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
            bean.setOrder(Integer.MIN_VALUE);
            logger.info("Auto configuration >> cross-domain configuration done -> order [{}]", (Object)Integer.MIN_VALUE);
            return bean;
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"yusp.filter.access.enabled"}, havingValue="true")
    @ConditionalOnClass(name={"cn.com.yusys.yusp.commons.session.SessionService"})
    static class AccessFilterAutoConfiguration {
        public final Integer FILTER_ORDER_ACCESS = 98;

        AccessFilterAutoConfiguration() {
        }

        @Bean
        public FilterRegistrationBean<Filter> accessFilterBean(WebProperties webProperties, WebFilterProperties webFilterProperties) {
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)new AccessFilter(), new ServletRegistrationBean[0]);
            registration.setOrder(this.FILTER_ORDER_ACCESS.intValue());
            registration.addInitParameter("ignoreUrls", webProperties.getIgnoreUrls());
            registration.addInitParameter("ignoreResource", webProperties.getIgnoreResources());
            registration.addInitParameter("enableServiceAuthorityFilter", Boolean.toString(webFilterProperties.getServiceAuthority().isEnabled()));
            logger.info("Access file has register success!");
            return registration;
        }
    }
}

