/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.starter;

import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=-2147483647)
public class CommonsEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String COMMONS_PROPERTY_SOURCE_NAME = "CommonsProperties";
    private static final List<String> BOOTSTRAP_PROPERTIES = Collections.unmodifiableList(ListUtils.newArrayList((Object[])new String[]{"spring.cloud.client.ip-address", "spring.application.name", "server.port"}));

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("spring.jackson.serialization.INDENT_OUTPUT", true);
        map.put("management.endpoints.enabled-by-default", true);
        map.put("management.endpoint.health.show-details", "always");
        map.put("management.health.mail.enabled", false);
        map.put("eureka.instance.prefer-ip-address", true);
        if (BOOTSTRAP_PROPERTIES.stream().allMatch(arg_0 -> ((ConfigurableEnvironment)environment).containsProperty(arg_0))) {
            map.put("eureka.instance.instance-id", "${spring.cloud.client.ip-address}:${spring.application.name}:${server.port}");
        }
        map.put("feign.httpclient.enabled", false);
        map.put("feign.okhttp.enabled", true);
        map.put("mybatis-plus.configuration.map-underscore-to-camel-case", true);
        map.put("mybatis-plus.configuration.jdbc-type-for-null", "'null'");
        map.put("mybatis-mapper.configuration.map-underscore-to-camel-case", true);
        map.put("mybatis-mapper.configuration.jdbc-type-for-null", "'null'");
        map.put("spring.mvc.favicon.enabled", false);
        map.put("spring.main.allow-bean-definition-overriding", true);
        map.put("spring.sleuth.enabled", true);
        map.put("server.error.include-message", "always");
        map.keySet().removeIf(key -> environment.getProperty(key) != null);
        MapPropertySource target = (MapPropertySource)environment.getPropertySources().get(COMMONS_PROPERTY_SOURCE_NAME);
        if (target == null) {
            target = new MapPropertySource(COMMONS_PROPERTY_SOURCE_NAME, map);
        }
        environment.getPropertySources().addLast((PropertySource)target);
    }
}

