/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.web.filter;

import cn.com.yusys.yusp.commons.session.user.Control;
import cn.com.yusys.yusp.commons.session.user.MenuControl;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BooleanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class AccessFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AccessFilter.class);
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    public static final String IGNORE_URLS_KEY = "ignoreUrls";
    public static final String IGNORE_RESOURCE_KEY = "ignoreResource";
    public static final String ENABLE_SERVICE_AUTH_KEY = "enableServiceAuthorityFilter";
    private boolean enableServiceAuthorityFilter = false;
    private List<String> ignoreUrls;
    private List<String> ignoreResources;
    private static final int MAX_REFRESH_TIME = 60000;
    private List<? extends Control> needAuthUrls;
    private long lastRefresh = System.currentTimeMillis();

    public void init(FilterConfig filterConfig) {
        log.info("Create access permission interceptor!");
        String ignoreUrlStr = filterConfig.getInitParameter(IGNORE_URLS_KEY);
        String ignoreResourceStr = filterConfig.getInitParameter(IGNORE_RESOURCE_KEY);
        String enabledFilter = filterConfig.getInitParameter(ENABLE_SERVICE_AUTH_KEY);
        this.enableServiceAuthorityFilter = BooleanUtils.toBoolean((String)enabledFilter);
        if (StringUtils.nonEmpty((CharSequence)ignoreUrlStr)) {
            this.ignoreUrls = Arrays.stream(ignoreUrlStr.split(",")).map(String::trim).collect(Collectors.toList());
        }
        if (StringUtils.nonEmpty((CharSequence)ignoreResourceStr)) {
            this.ignoreResources = Arrays.stream(ignoreResourceStr.split(",")).map(String::trim).collect(Collectors.toList());
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String appName;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean doAuthFilter = true;
        if (this.enableServiceAuthorityFilter && StringUtils.nonBlank((CharSequence)(appName = request.getHeader("appName")))) {
            doAuthFilter = false;
        }
        if (doAuthFilter) {
            String requestUri = this.pathHelper.getLookupPathForRequest(request);
            if (log.isDebugEnabled()) {
                log.debug("CompatibilityAccessFilter enter url:[{}] ,ip:[{}:{}]", new Object[]{requestUri, servletRequest.getRemoteAddr(), servletRequest.getRemotePort()});
            }
            boolean isAuthorized = false;
            if (null != this.ignoreUrls) {
                isAuthorized = this.ignoreUrls.stream().anyMatch(ctrl -> this.matcher.matchStart(ctrl, requestUri));
            }
            if (!isAuthorized && null != this.ignoreResources) {
                isAuthorized = this.ignoreResources.stream().anyMatch(requestUri::endsWith);
            }
            try {
                if (!isAuthorized) {
                    String userId = SessionUtils.getUserId();
                    log.info("accessFilter userId: " + userId);
                    if (userId == null) {
                        log.error("UserContext information not obtained in request [{}], request not authorized", (Object)requestUri);
                    } else {
                        if (this.needAuthUrls == null || System.currentTimeMillis() - this.lastRefresh > 60000L) {
                            this.needAuthUrls = SessionUtils.getAllControls();
                            this.lastRefresh = System.currentTimeMillis();
                        }
                        if (null != this.needAuthUrls && !this.needAuthUrls.isEmpty()) {
                            boolean requestUriNeedAuth = this.needAuthUrls.stream().anyMatch(ctrl -> this.matcher.match(ctrl.getContrUrl() == null ? "" : ctrl.getContrUrl(), requestUri));
                            if (requestUriNeedAuth) {
                                MenuControl menuControl = SessionUtils.getMenuControl();
                                List contrList = menuControl.getContr();
                                if (contrList != null && contrList.size() > 0) {
                                    isAuthorized = contrList.stream().anyMatch(ctrl -> Objects.nonNull(ctrl.getContrUrl()) && this.matcher.match(ctrl.getContrUrl() == null ? null : ctrl.getContrUrl(), requestUri));
                                }
                            } else {
                                isAuthorized = true;
                            }
                        }
                    }
                }
                if (!isAuthorized) {
                    response.sendError(403, "user forbidden from yusp access filter");
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

