/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.BillTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ExporterImporter;
import cn.com.yusys.yusp.commons.excelcsv.async.AsyncPoolServiceExecutor;
import cn.com.yusys.yusp.commons.excelcsv.async.ExportContext;
import cn.com.yusys.yusp.commons.excelcsv.async.ImportContext;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.model.CustomDefine;
import cn.com.yusys.yusp.commons.progress.model.ProgressDto;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static AsyncPoolServiceExecutor executor;
    private static String tempDir;
    private static int batchSize;
    private static int sheetMaxRow;
    private static final AtomicBoolean INITIATING;

    public static void initiating(AsyncPoolServiceExecutor executor, String tempDir, int batchSize, int sheetMaxRow) {
        Asserts.nonNull((Object)executor, (Object[])new Object[]{"Async pool executor must not null!"});
        Asserts.nonEmpty((CharSequence)tempDir, (Object[])new Object[]{" Temporary file storage path cannot be empty!"});
        if (INITIATING.compareAndSet(false, true)) {
            ExcelUtils.executor = executor;
            ExcelUtils.tempDir = tempDir;
            if (batchSize > 0) {
                ExcelUtils.batchSize = batchSize;
            }
            ExcelUtils.sheetMaxRow = sheetMaxRow;
        }
    }

    public static ProgressDto asyncExport(ExportContext exportContext) {
        return executor.executeExport(exportContext);
    }

    public static File syncExport(ExportContext exportContext, Object model) {
        return ExcelUtils.syncExport(exportContext.getHeadClass(), model, exportContext.getDataHandle(), exportContext.getCustomDefine());
    }

    public static File syncExport(Class<?> headClass, Object model) {
        return ExcelUtils.syncExport(headClass, model, (DataHandle)ExporterImporter.DEFAULT_DATA_HANDLE, null);
    }

    public static File syncExport(Class<?> headClass, Object model, DataHandle dataHandle) {
        return ExcelUtils.syncExport(headClass, model, dataHandle, null);
    }

    public static File syncExport(Class<?> headClass, Object model, DataHandle dataHandle, CustomDefine customDefine) {
        return new ExporterImporter(sheetMaxRow, tempDir).export(headClass, model, dataHandle, customDefine);
    }

    public static ProgressDto asyncImport(ImportContext importContext) {
        return executor.executeImport(importContext);
    }

    public static void syncImport(Class<?> headClass, File file, Consumer<Object> dataStorage) {
        ExcelUtils.syncImport(headClass, file, (DataHandle)ExporterImporter.DEFAULT_DATA_HANDLE, dataStorage, false);
    }

    public static void syncImport(Class<?> headClass, File file, Consumer<Object> dataStorage, boolean batch) {
        ExcelUtils.syncImport(headClass, file, (DataHandle)ExporterImporter.DEFAULT_DATA_HANDLE, dataStorage, batch);
    }

    public static void syncImport(Class<?> headClass, File file, DataHandle dataHandle, Consumer<Object> dataStorage) {
        ExcelUtils.syncImport(headClass, file, dataHandle, dataStorage, false);
    }

    public static void syncImport(Class<?> headClass, File file, DataHandle dataHandle, Consumer<Object> dataStorage, boolean batch) {
        new ExporterImporter(sheetMaxRow, tempDir).importData(headClass, file, dataHandle, dataStorage);
        if (batch) {
            dataStorage.accept(null);
        }
    }

    public static File getTemporaryFile(String suffix) {
        return ExcelUtils.getTemporaryFile(StringUtils.uuid((boolean)false), suffix);
    }

    public static File getTemporaryFile(String fileName, String suffix) {
        return new File(StringUtils.buffer0((Object[])new Object[]{tempDir, File.separator, fileName, suffix.startsWith(".") ? "" : ".", suffix}));
    }

    public static File toTemporaryFile(InputStream is, String actualFileName) {
        File tempFile = ExcelUtils.getTemporaryFile(actualFileName.substring(actualFileName.lastIndexOf(".")));
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tempFile;
    }

    public static <T> BatchConsumer batchConsumer(Function<List<T>, Integer> function, int maxRecord) {
        return new BatchConsumer<T>(function, maxRecord);
    }

    public static File exportByTemplate(String template, Object data, DataHandle dataHandle) {
        Asserts.nonEmpty((CharSequence)template, (Object[])new Object[]{"Template[%s] not empty!", template});
        int dotIndex = template.lastIndexOf(".");
        Asserts.maxNumber((Number)dotIndex, (Number)0, (Object[])new Object[]{"Template[%s] must announce file suffix!", template});
        String suffix = StringUtils.substr((String)template, (int)dotIndex, (int)template.length());
        return ExcelUtils.exportByTemplate(template, data, ExcelUtils.getTemporaryFile(suffix), dataHandle);
    }

    private static File exportByTemplate(String template, Object data, File outFile, DataHandle dataHandle) {
        byte[] tempBytes;
        try (InputStream is = BillTemplate.class.getClassLoader().getResourceAsStream(template);){
            assert (is != null);
            tempBytes = IOUtils.readBytes((InputStream)is, (boolean)false);
        }
        catch (Exception e) {
            logger.error(String.format("Can not find template:%s", template), (Throwable)e);
            return null;
        }
        BillTemplate billTemplate = new BillTemplate(tempBytes, dataHandle);
        billTemplate.export(data, outFile);
        return outFile;
    }

    public static File exportByTemplate(String template, Object data, String outFile, DataHandle dataHandle) {
        Asserts.nonEmpty((CharSequence)template, (Object[])new Object[]{"Template[%s] not empty!", template});
        int dotIndex = template.lastIndexOf(".");
        Asserts.maxNumber((Number)dotIndex, (Number)0, (Object[])new Object[]{"Template[%s] must announce file suffix!", template});
        String suffix = StringUtils.substr((String)template, (int)dotIndex, (int)template.length());
        String outSuffix = StringUtils.substr((String)outFile, (int)outFile.lastIndexOf("."), (int)outFile.length());
        Asserts.isEquals((Object)suffix, (Object)outSuffix, (Object[])new Object[]{"Template file sufiix:%s Must be the same as out file suffix:%s", suffix, outSuffix});
        return ExcelUtils.exportByTemplate(template, data, new File(outFile), dataHandle);
    }

    public static <T> BatchConsumer batchConsumer(Function<List<T>, Integer> function) {
        return ExcelUtils.batchConsumer(function, batchSize);
    }

    static {
        batchSize = 2000;
        INITIATING = new AtomicBoolean(false);
    }

    static class BatchConsumer<T>
    implements Consumer<T> {
        private final Function<List<T>, Integer> function;
        private final int maxRecord;
        List<T> list = new ArrayList<T>();

        @Override
        public void accept(Object o) {
            if (o == null) {
                this.apply();
            } else {
                this.list.add(o);
                if (this.list.size() == this.maxRecord) {
                    this.apply();
                }
            }
        }

        public BatchConsumer(Function<List<T>, Integer> function, int maxRecord) {
            Asserts.nonNull(function, (Object[])new Object[]{"Custom function must not null!"});
            Asserts.minNumber((Number)0, (Number)maxRecord, (Object[])new Object[]{"Max Record must more than the zero!"});
            this.function = function;
            this.maxRecord = maxRecord;
        }

        private void apply() {
            if (CollectionUtils.nonEmpty(this.list)) {
                this.function.apply(this.list);
                this.list.clear();
            }
        }
    }
}

