/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.jdbc.core.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractConnectionAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteCallback;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.DataSourceRouteHandler;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.context.ShardingRuntimeContext;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.metadata.ShardingDatabaseMetaData;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingPreparedStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;
import org.apache.shardingsphere.underlying.executor.constant.ConnectionMode;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRuntimeContext runtimeContext;
    private final TransactionType transactionType;
    private final ShardingTransactionManager shardingTransactionManager;

    public ShardingConnection(Map<String, DataSource> dataSourceMap, ShardingRuntimeContext runtimeContext, TransactionType transactionType) {
        this.dataSourceMap = dataSourceMap;
        this.runtimeContext = runtimeContext;
        this.transactionType = transactionType;
        this.shardingTransactionManager = runtimeContext.getShardingTransactionManagerEngine().getTransactionManager(transactionType);
    }

    public boolean isHoldTransaction() {
        return TransactionType.LOCAL == this.transactionType && !this.getAutoCommit() || TransactionType.XA == this.transactionType && this.isInShardingTransaction();
    }

    protected Connection createConnection(String dataSourceName, DataSource dataSource) throws SQLException {
        return this.isInShardingTransaction() ? this.shardingTransactionManager.getConnection(dataSourceName) : dataSource.getConnection();
    }

    private boolean isInShardingTransaction() {
        return null != this.shardingTransactionManager && this.shardingTransactionManager.isInTransaction();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getCachedConnections().isEmpty() ? new ShardingDatabaseMetaData(this) : ((Connection)this.getCachedConnections().values().iterator().next()).getMetaData();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).prepareStatement(sql);
        }
        return new ShardingPreparedStatement(this, sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).prepareStatement(sql, autoGeneratedKeys);
        }
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).prepareStatement(sql, columnIndexes);
        }
        return new ShardingPreparedStatement(this, sql, 1);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).prepareStatement(sql, columnNames);
        }
        return new ShardingPreparedStatement(this, sql, 1);
    }

    public Statement createStatement() throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).createStatement();
        }
        return new ShardingStatement(this);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).createStatement(resultSetType, resultSetConcurrency);
        }
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dataSourceName = DataSourceRouteHandler.DATA_SOURCE_NAME.get();
        if (null != dataSourceName && !"".equals(dataSourceName)) {
            return ((Connection)this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0)).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (TransactionType.LOCAL == this.transactionType) {
            super.setAutoCommit(autoCommit);
            return;
        }
        if (autoCommit && !this.shardingTransactionManager.isInTransaction() || !autoCommit && this.shardingTransactionManager.isInTransaction()) {
            return;
        }
        if (autoCommit && this.shardingTransactionManager.isInTransaction()) {
            this.shardingTransactionManager.commit();
            return;
        }
        if (!autoCommit && !this.shardingTransactionManager.isInTransaction()) {
            this.closeCachedConnections();
            this.shardingTransactionManager.begin();
        }
    }

    private void closeCachedConnections() throws SQLException {
        this.getForceExecuteTemplate().execute(this.getCachedConnections().values(), (ForceExecuteCallback)new ForceExecuteCallback<Connection>(){

            public void execute(Connection connection) throws SQLException {
                connection.close();
            }
        });
        this.getCachedConnections().clear();
    }

    public void commit() throws SQLException {
        if (TransactionType.LOCAL == this.transactionType) {
            super.commit();
        } else {
            this.shardingTransactionManager.commit();
        }
    }

    public void rollback() throws SQLException {
        if (TransactionType.LOCAL == this.transactionType) {
            super.rollback();
        } else {
            this.shardingTransactionManager.rollback();
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public ShardingTransactionManager getShardingTransactionManager() {
        return this.shardingTransactionManager;
    }
}

