/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.support;

import cn.com.yusys.yusp.commons.session.SessionService;
import cn.com.yusys.yusp.commons.session.user.Control;
import cn.com.yusys.yusp.commons.session.user.DataControl;
import cn.com.yusys.yusp.commons.session.user.MenuControl;
import cn.com.yusys.yusp.commons.session.user.User;
import cn.com.yusys.yusp.commons.session.user.UserData;
import java.util.List;
import java.util.Objects;
import org.springframework.cache.annotation.Cacheable;

public class CacheableSessionService
implements SessionService {
    private final SessionService delegate;

    public CacheableSessionService(SessionService delegate) {
        this.delegate = Objects.nonNull(delegate) ? delegate : new SessionService.DefaultSessionService();
    }

    @Override
    @Cacheable(value={"Control@-1"}, key="'allContrUrl'")
    public List<? extends Control> getAllControls() {
        return this.delegate.getAllControls();
    }

    @Override
    @Cacheable(value={"Session"}, key="#p0+'-'+#p1")
    public User getUserInfo(String clientId, String userId) {
        return this.delegate.getUserInfo(clientId, userId);
    }

    @Override
    @Cacheable(value={"MenuControl"}, key="#p0+'-'+#p1")
    public MenuControl getMenuControl(String clientId, String userId) {
        return this.delegate.getMenuControl(clientId, userId);
    }

    @Override
    @Cacheable(value={"DataControl"}, key="#p0+'-'+#p1")
    public List<? extends DataControl> getDataControl(String clientId, String userId) {
        return this.delegate.getDataControl(clientId, userId);
    }

    @Override
    @Cacheable(value={"UserDataInfo"}, key="#p0+'-'+#p1")
    public UserData getUserDataInfo(String clientId, String userId) {
        return this.delegate.getUserDataInfo(clientId, userId);
    }
}

