/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf;

import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdNotExistException;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.model.IdGenEntity;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.model.Segment;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.model.SegmentBuffer;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.service.IdGenService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IdGenImpl {
    Logger logger = LoggerFactory.getLogger(IdGenImpl.class);
    private ExecutorService service = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "id-gen-thread"));
    private Map<String, SegmentBuffer> cache = new ConcurrentHashMap<String, SegmentBuffer>();
    private Map<String, Boolean> seqConfig = new ConcurrentHashMap<String, Boolean>();
    private IdGenService idGenService;

    @Autowired
    public IdGenImpl(IdGenService idGenService) {
        this.idGenService = idGenService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String key) {
        if (this.seqConfig.get(key).booleanValue()) {
            return true;
        }
        IdGenImpl idGenImpl = this;
        synchronized (idGenImpl) {
            if (this.seqConfig.get(key).booleanValue()) {
                return true;
            }
            this.updateCacheFromDB();
            if (!this.cache.containsKey(key)) {
                this.createSequence(key);
                this.updateCacheFromDB();
            }
            this.seqConfig.put(key, true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId(String key, long limit, SequenceConfig config) {
        this.seqConfig.putIfAbsent(key, false);
        if (!this.init(key)) {
            throw new RuntimeException("\u7f13\u5b58\u521d\u59cb\u5316\u5931\u8d25\u3002");
        }
        if (this.cache.containsKey(key)) {
            SegmentBuffer segmentBuffer = this.cache.get(key);
            int retryCount = 0;
            while (!segmentBuffer.isInitOK()) {
                String lastExceptionMessage = null;
                SegmentBuffer segmentBuffer2 = segmentBuffer;
                synchronized (segmentBuffer2) {
                    try {
                        if (!segmentBuffer.isInitOK()) {
                            this.updateSegmentFromDB(key, segmentBuffer.getCurrentSegment(), limit, config);
                            segmentBuffer.setInitOK(true);
                        }
                    }
                    catch (SequenceException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        lastExceptionMessage = e.getMessage();
                        ++retryCount;
                    }
                    if (retryCount > 5) {
                        throw new SequenceException(lastExceptionMessage);
                    }
                }
            }
            return this.getIdFromSegmentBuffer(segmentBuffer, limit, config);
        }
        throw new SequenceIdNotExistException("\u5e8f\u5217\u53f7\u4ee3\u7801\u4e0d\u5b58\u5728\uff01");
    }

    void updateCacheFromDB() {
        try {
            List<String> dbKeys = this.idGenService.getAllKeys();
            this.logger.debug("\u7ebf\u7a0b:{}\uff0cdbKeys:{}", (Object)Thread.currentThread().getName(), dbKeys);
            HashSet<String> cacheKeys = new HashSet<String>(this.cache.keySet());
            HashSet<String> addKeys = new HashSet<String>(dbKeys);
            HashSet<String> rmKeys = new HashSet<String>(cacheKeys);
            addKeys.removeIf(cacheKeys::contains);
            for (String addKey : addKeys) {
                SegmentBuffer segmentBuffer = new SegmentBuffer();
                segmentBuffer.setKey(addKey);
                Segment currentSegment = segmentBuffer.getCurrentSegment();
                currentSegment.setValue(new AtomicLong(0L));
                currentSegment.setMax(0L);
                currentSegment.setStep(0L);
                this.cache.put(addKey, segmentBuffer);
                this.logger.debug("\u6dfb\u52a0\u65b0\u589e\u7684\u5e8f\u5217\u53f7\u4ee3\u7801\uff1a{}\u3002", (Object)addKey);
            }
            rmKeys.removeIf(dbKeys::contains);
            for (String rmKey : rmKeys) {
                this.cache.remove(rmKey);
                this.seqConfig.remove(rmKey);
                this.logger.debug("\u5220\u9664\u8fc7\u671f\u7684\u5e8f\u5217\u53f7\u4ee3\u7801\uff1a{}\u3002", (Object)rmKey);
            }
        }
        catch (Exception e) {
            this.logger.warn("\u66f4\u65b0\u7f13\u5b58\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    void updateSegmentFromDB(String key, Segment segment, long limit, SequenceConfig config) {
        SegmentBuffer segmentBuffer = segment.getSegmentBuffer();
        IdGenEntity idGenEntity = CycleType.MAX.equals((Object)config.getCycleType()) ? this.idGenService.setMaxIdAndGetIdGenCycle(key, limit) : this.idGenService.setMaxIdAndGetIdGen(key, limit);
        if (idGenEntity.getIsMax() == 1 && !config.getCycleType().equals((Object)CycleType.MAX)) {
            throw new SequenceException("\u5f53\u524d\u5e8f\u5217\u53f7\u6a21\u677f\u5df2\u8fbe\u5230\u6700\u5927\u503c\uff0c\u8bf7\u8bbe\u7f6e\u5faa\u73af\u6216\u65b0\u5efa\u5e8f\u5217\uff01");
        }
        long value = idGenEntity.getMaxId() != limit ? idGenEntity.getMaxId() - idGenEntity.getStep() + 1L : segmentBuffer.getCurrentSegment().getMax() + 1L;
        segment.setMax(idGenEntity.getMaxId());
        segment.setStep(idGenEntity.getStep());
        segment.getValue().set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getIdFromSegmentBuffer(SegmentBuffer segmentBuffer, long limit, SequenceConfig config) {
        while (true) {
            long value;
            Segment currentSegment;
            segmentBuffer.getRLock().lock();
            try {
                currentSegment = segmentBuffer.getCurrentSegment();
                if (!segmentBuffer.isNextReady() && (double)currentSegment.getRestCount() < 0.9 * (double)currentSegment.getStep() && segmentBuffer.getThreadRunning().compareAndSet(false, true)) {
                    this.service.execute(() -> {
                        Segment nextSegment = segmentBuffer.getSegments()[segmentBuffer.nextIndex()];
                        boolean isUpdateOk = false;
                        try {
                            this.updateSegmentFromDB(segmentBuffer.getKey(), nextSegment, limit, config);
                            isUpdateOk = true;
                            this.logger.info("\u6210\u529f\u66f4\u65b0\u5e8f\u5217\u53f7\u4ee3\u7801\u4e3a {} \u7684\u5907\u7528segment{}\u3002", (Object)segmentBuffer.getKey(), (Object)nextSegment);
                        }
                        catch (Exception e) {
                            this.logger.warn("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                        }
                        finally {
                            if (isUpdateOk) {
                                segmentBuffer.getWLock().lock();
                                segmentBuffer.setNextReady(true);
                                segmentBuffer.getThreadRunning().set(false);
                                segmentBuffer.getWLock().unlock();
                            } else {
                                segmentBuffer.getThreadRunning().set(false);
                            }
                        }
                    });
                }
                if ((value = currentSegment.getValue().getAndIncrement()) <= currentSegment.getMax()) {
                    long l = value;
                    return l;
                }
                if (value > limit && !CycleType.MAX.equals((Object)config.getCycleType())) {
                    this.idGenService.updateStatus(segmentBuffer.getKey(), 1);
                    throw new SequenceException("\u5f53\u524d\u5e8f\u5217\u53f7\u6a21\u677f\u5df2\u8fbe\u5230\u6700\u5927\u503c\uff0c\u8bf7\u8bbe\u7f6e\u5faa\u73af\u6216\u65b0\u5efa\u5e8f\u5217\uff01");
                }
            }
            finally {
                segmentBuffer.getRLock().unlock();
            }
            this.waitAndSleep(segmentBuffer);
            segmentBuffer.getWLock().lock();
            try {
                currentSegment = segmentBuffer.getCurrentSegment();
                value = currentSegment.getValue().getAndIncrement();
                if (value <= currentSegment.getMax()) {
                    long l = value;
                    return l;
                }
                if (!segmentBuffer.isNextReady()) continue;
                segmentBuffer.switchSegment();
                segmentBuffer.setNextReady(false);
                this.logger.info("\u5207\u6362\u5230\u5907\u7528segment\u3002");
                continue;
            }
            finally {
                segmentBuffer.getWLock().unlock();
                continue;
            }
            break;
        }
    }

    private void waitAndSleep(SegmentBuffer buffer) {
        int roll = 0;
        while (buffer.getThreadRunning().get()) {
            if (++roll <= 10000) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                this.logger.warn("Thread {} Interrupted", (Object)Thread.currentThread().getName());
            }
            break;
        }
    }

    public void createSequence(String seqId) {
        this.idGenService.createSequence(seqId);
    }

    public int dropSequence(String seqId) {
        return this.idGenService.dropSequence(seqId);
    }
}

