/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.db;

import cn.com.yusys.yusp.commons.enumeration.DbType;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.sequence.generator.db.AbstractDatabaseSequenceGenerator;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleSequenceGenerator
extends AbstractDatabaseSequenceGenerator {
    public OracleSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, JdbcTemplate jdbcTemplate) {
        super(sequenceConfigs, sequenceIdConverter, jdbcTemplate);
    }

    @Override
    String querySql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"select count(*) from user_sequences where sequence_name = '", seqId, "'"});
    }

    @Override
    String dropSql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"drop sequence ", seqId});
    }

    @Override
    String createSql(String seqId, SequenceConfig config) {
        return StringUtils.builder0((Object[])new Object[]{"create sequence ", seqId, " minvalue ", config.getStartValue(), " maxvalue ", config.getMaxValue(), " start with ", config.getStartValue(), " increment by ", config.getIncrementValue(), " cache ", config.getCacheValue(), CycleType.MAX.equals((Object)config.getCycleType()) ? " cycle " : ""});
    }

    @Override
    String batchNextSql(String seqId, int number) {
        return StringUtils.builder0((Object[])new Object[]{"select to_char(", seqId, ".nextval) from (select 1 from user_objects where rownum <= ", number, ")"});
    }

    @Override
    String currentSql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"select to_char(", seqId, ".currval) from dual"});
    }

    @Override
    protected String nextSql(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{"select to_char(", seqId, ".nextval) from dual"});
    }

    @Override
    public List<String> getBatchSequence(String seqId, int number, Map<String, String> paramMap) throws SequenceException {
        Asserts.maxNumber((Number)number, (Number)0, (Object[])new Object[]{"get sequence number must  Greater than or equal to zero!"});
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        List<String> sequences = this.executeQuery(this.batchNextSql(convertSeqId, number), this.batchNextSql(convertSeqId, number), convertSeqId, this.getSequenceConfig(seqId));
        return CollectionUtils.nonEmpty(sequences) ? this.parseSequenceByTemplate(convertSeqId, sequences, paramMap) : Collections.emptyList();
    }

    public boolean isSupported(DbType type) {
        return DbType.ORACLE.equals((Object)type);
    }

    public String supportedType() {
        return GeneratorType.ORACLE.name();
    }
}

