/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.nosql;

import cn.com.yusys.yusp.commons.sequence.AbstractSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class RedisSequenceGenerator
extends AbstractSequenceGenerator {
    private StringRedisTemplate stringRedisTemplate;
    private static final String KEY_GROUP_PREFIX = "Sequence:";

    public RedisSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, StringRedisTemplate stringRedisTemplate) {
        super(sequenceConfigs, sequenceIdConverter);
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public long getCurrentSequenceNo(String seqId) {
        String resetSeqId = this.resetSeqId(seqId);
        Boolean hasKey = this.stringRedisTemplate.hasKey((Object)resetSeqId);
        SequenceConfig config = this.getSequenceConfig(seqId);
        if (Objects.nonNull(hasKey) && hasKey.booleanValue()) {
            long currentSeq = new RedisAtomicLong(resetSeqId, this.stringRedisTemplate.getConnectionFactory()).get();
            return currentSeq < config.getStartValue() ? config.getStartValue() : currentSeq;
        }
        return config.getStartValue();
    }

    @Override
    public String getSequence(String seqId, Map<String, String> paramMap) throws SequenceException {
        return this.parseSequenceByTemplate(seqId, String.valueOf(this.getSequenceNo(seqId)), paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSequenceNo(String seqId) throws SequenceException {
        long currValue;
        String resetSeqId = this.resetSeqId(seqId);
        SequenceConfig config = this.getSequenceConfig(seqId);
        Boolean hasKey = this.stringRedisTemplate.hasKey((Object)resetSeqId);
        if (Objects.isNull(hasKey) || !hasKey.booleanValue()) {
            Object object = this.getLockObject(seqId);
            synchronized (object) {
                hasKey = this.stringRedisTemplate.hasKey((Object)resetSeqId);
                if (Objects.isNull(hasKey) || !hasKey.booleanValue()) {
                    return new RedisAtomicLong(resetSeqId, this.stringRedisTemplate.getConnectionFactory(), config.getStartValue().longValue()).get();
                }
            }
        }
        RedisAtomicLong counter = new RedisAtomicLong(resetSeqId, this.stringRedisTemplate.getConnectionFactory());
        Long incrementValue = config.getIncrementValue();
        Long maxValue = config.getMaxValue();
        if (maxValue.compareTo(currValue = counter.addAndGet(incrementValue.longValue())) < 0) {
            if (CycleType.MAX.equals((Object)config.getCycleType())) {
                Long startValue = config.getStartValue();
                counter.set((long)startValue.intValue());
                currValue = startValue;
            } else {
                throw new SequenceException(String.format("Seq [%s] has reached its maximum !!!", seqId));
            }
        }
        return currValue;
    }

    @Override
    public boolean dropSequence(String seqId, boolean removeConfig) {
        Boolean result = this.stringRedisTemplate.delete((Object)(seqId = this.resetSeqId(seqId)));
        if (Objects.nonNull(result) && result.booleanValue()) {
            return super.dropSequence(seqId, removeConfig);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSequence(String seqId) throws SequenceException {
        String redisSeqId = this.resetSeqId(seqId);
        Object object = this.getLockObject(seqId);
        synchronized (object) {
            Boolean hasKey = this.stringRedisTemplate.hasKey((Object)redisSeqId);
            if (Objects.nonNull(hasKey) && hasKey.booleanValue()) {
                throw new SequenceException("\u5df2\u5b58\u5728\u5e8f\u5217\u53f7");
            }
        }
        RedisAtomicLong counter = new RedisAtomicLong(redisSeqId, this.stringRedisTemplate.getConnectionFactory());
        SequenceConfig config = this.getSequenceConfig(seqId);
        Asserts.nonNull((Object)config, (Object[])new Object[]{"Current sequence id is not found config info!"});
        counter.set(config.getStartValue() - config.getIncrementValue());
        return true;
    }

    private String resetSeqId(String seqId) {
        return StringUtils.builder0((Object[])new Object[]{KEY_GROUP_PREFIX, this.getSequenceIdConverter().convert(seqId)});
    }

    @Override
    public int cleanup(String ... seqIds) {
        return Optional.ofNullable(this.stringRedisTemplate.delete((Collection)ListUtils.newArrayList((Object[])seqIds))).orElse(0L).intValue();
    }

    public String supportedType() {
        return GeneratorType.REDIS.name();
    }
}

