/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.db;

import cn.com.yusys.yusp.commons.enumeration.DbType;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.sequence.generator.db.AbstractDatabaseSequenceGenerator;
import cn.com.yusys.yusp.commons.util.CompareUtils;
import cn.com.yusys.yusp.commons.util.DataSourceUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class MySqlSequenceGenerator
extends AbstractDatabaseSequenceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MySqlSequenceGenerator.class);
    static final Pattern connectionPattern = Pattern.compile("jdbc:(.*?)//(.*?)/");
    static final String defaultQueryTableSql = "select count(0) from information_schema.TABLES where TABLE_NAME  = 'sequence' %s";
    final String queryTableSql;
    static final String createTableSql = "CREATE TABLE If Not Exists sequence (name varchar(50) NOT NULL , current_value bigint(20) NOT NULL DEFAULT 0 , increment int(11) NOT NULL DEFAULT 1 , already_next char(1) NOT NULL DEFAULT '0' ,PRIMARY KEY (name))";
    static final String dropFunctionSql = "DROP FUNCTION IF EXISTS currval";
    static final String createCurrFunctionSql = "CREATE FUNCTION currval(seq_name VARCHAR(50)) RETURNS BIGINT DETERMINISTIC READS SQL DATA  CONTAINS SQL BEGIN DECLARE value BIGINT; SELECT current_value INTO value FROM sequence  WHERE name = seq_name; RETURN value; END;";
    static final String dropNextFunctionSql = "DROP FUNCTION IF EXISTS nextval";
    static final String createNextFunctionSql = "CREATE FUNCTION nextval (seq_name VARCHAR(50)) RETURNS BIGINT DETERMINISTIC MODIFIES SQL DATA  CONTAINS SQL BEGIN DECLARE value BIGINT; UPDATE sequence SET current_value = IF(already_next='0',current_value,current_value + increment ),already_next='1'  WHERE name = seq_name; RETURN currval(seq_name); END;";
    static final String updateSequenceWhileMaxCycle = "UPDATE sequence set current_value = '%s' where name = '%s'";

    public MySqlSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, JdbcTemplate jdbcTemplate) {
        super(sequenceConfigs, sequenceIdConverter, jdbcTemplate);
        String schema = MySqlSequenceGenerator.getSchema(jdbcTemplate.getDataSource());
        this.queryTableSql = String.format(defaultQueryTableSql, StringUtils.nonEmpty((CharSequence)schema) ? " and table_schema = '" + schema + "'" : "");
    }

    @Override
    protected void createSequence(String seqId, SequenceConfig sequenceConfig, Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.queryTableSql);){
            if (rs.next() && "0".equals(rs.getString(1))) {
                stmt.execute(createTableSql);
                stmt.execute(dropFunctionSql);
                stmt.execute(createCurrFunctionSql);
                stmt.execute(dropNextFunctionSql);
                stmt.execute(createNextFunctionSql);
            }
            stmt.execute(this.createSql(seqId, sequenceConfig));
        }
    }

    @Override
    public long getSequenceNo(String seqId) throws SequenceException {
        long nextSequence = super.getSequenceNo(seqId);
        if (nextSequence > -1L) {
            SequenceConfig config = this.getSequenceConfig(seqId);
            long maxValue = config.getMaxValue();
            if (CompareUtils.compare((Comparable)Long.valueOf(nextSequence), (Comparable)Long.valueOf(maxValue)) > 0) {
                if (CycleType.MAX.equals((Object)config.getCycleType())) {
                    String updateCycleSql = String.format(updateSequenceWhileMaxCycle, config.getStartValue(), this.getSequenceIdConverter().convert(seqId));
                    try {
                        DataSourceUtils.executeUpdateScript((DataSource)this.getJdbcTemplate().getDataSource(), (String)updateCycleSql);
                        return config.getStartValue();
                    }
                    catch (Exception e) {
                        throw new SequenceException(e);
                    }
                }
                String errorMessage = String.format("Current sequence id:%s The maximum configured value has been exceeded, but there is no configuration loop, and the acquisition fails", seqId);
                logger.error(errorMessage);
                throw new SequenceException(errorMessage);
            }
        }
        return nextSequence;
    }

    @Override
    public long getCurrentSequenceNo(String seqId) throws SequenceException {
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        List<String> sequences = this.executeQuery(this.currentSql(convertSeqId), this.currentSql(convertSeqId), convertSeqId, this.getSequenceConfig(seqId));
        return CollectionUtils.nonEmpty(sequences) ? Long.parseLong(sequences.get(0)) : -1L;
    }

    @Override
    String querySql(String seqId) {
        return String.format("select count(0) from sequence where name = '%s'", seqId);
    }

    @Override
    String batchNextSql(String sequenceName, int number) {
        throw new UnsupportedOperationException("current database is not supported batch get sequence sql!");
    }

    @Override
    String dropSql(String seqId) {
        return String.format("delete from sequence where name = '%s'", seqId);
    }

    @Override
    String createSql(String seqId, SequenceConfig config) {
        return String.format("INSERT INTO sequence(name, current_value, increment, already_next) VALUES ('%s', '%s', '%s', '%s')", seqId, config.getStartValue(), config.getIncrementValue(), Character.valueOf('0'));
    }

    @Override
    protected String nextSql(String seqId) {
        return String.format("select nextval('%s')", seqId);
    }

    @Override
    String currentSql(String seqId) {
        return String.format("SELECT current_value FROM sequence WHERE NAME = '%s'", seqId);
    }

    public boolean isSupported(DbType type) {
        return DbType.MYSQL.equals((Object)type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSchema(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            int questionMarkIndex;
            String connectUrl = connection.getMetaData().getURL();
            Matcher matcher = connectionPattern.matcher(connectUrl);
            if (matcher.find()) {
                connectUrl = matcher.replaceAll("");
            }
            String string = (questionMarkIndex = connectUrl.indexOf("?")) < 0 ? connectUrl : connectUrl.substring(0, questionMarkIndex);
            return string;
        }
        catch (Exception e) {
            logger.error("Get mysql database current connection schema occur exception! cause by:{}", (Object)e.getMessage());
            return "";
        }
    }

    @Override
    public int cleanup(String ... seqIds) {
        return super.cleanup(Arrays.stream(seqIds).map(seqId -> StringUtils.builder0((Object[])new Object[]{"'", seqId, "'"})).reduce((xva$0, xva$1) -> StringUtils.concat((String[])new String[]{xva$0, xva$1})).orElse(""));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int cleanup(Statement statement, String seqId) {
        if (StringUtils.isEmpty((CharSequence)seqId)) {
            return 0;
        }
        try (ResultSet rs = statement.executeQuery(String.format("delete from sequence where name in (%s)", seqId));){
            int n = rs.next() ? rs.getInt(1) : 0;
            return n;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String supportedType() {
        return GeneratorType.MYSQL.name();
    }
}

