/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence;

import cn.com.yusys.yusp.commons.sequence.Sequence;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.collection.MapUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSequence
implements Sequence {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSequence.class);
    public static final String OPEN_DAY_KEY = "openDay";
    private static final Pattern OPEN_DAY_PATTERN = Pattern.compile(":|\\-|/| ");
    private static final Map<String, SequenceConfig> sequenceConfigMap = new ConcurrentHashMap<String, SequenceConfig>();
    private final SequenceIdConverter sequenceIdConverter;

    public AbstractSequence(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter) {
        SequenceIdConverter sequenceIdConverter2 = this.sequenceIdConverter = Objects.nonNull(sequenceIdConverter) ? sequenceIdConverter : new SequenceIdConverter.DefaultConverter();
        if (CollectionUtils.nonEmpty(sequenceConfigs)) {
            sequenceConfigs.forEach(config -> sequenceConfigMap.putIfAbsent(this.sequenceIdConverter.convert(config.getSeqId()), (SequenceConfig)config));
        }
    }

    public AbstractSequence(List<SequenceConfig> sequenceConfigs) {
        this(sequenceConfigs, new SequenceIdConverter.DefaultConverter());
    }

    public SequenceConfig getSequenceConfig(String seqId) {
        return sequenceConfigMap.getOrDefault(this.sequenceIdConverter.convert(seqId), null);
    }

    public String parseSequenceByTemplate(String seqId, String sequenceNo, Map<String, String> paramMap) {
        List<String> sequences = this.parseSequenceByTemplate(seqId, Collections.singletonList(sequenceNo), paramMap);
        return CollectionUtils.nonEmpty(sequences) ? sequences.get(0) : sequenceNo;
    }

    public List<String> parseSequenceByTemplate(String seqId, List<String> sequenceNos, Map<String, String> paramMap) {
        if (StringUtils.isEmpty((CharSequence)seqId) || CollectionUtils.isEmpty(sequenceNos)) {
            return sequenceNos;
        }
        SequenceConfig sequenceConfig = this.getSequenceConfig(seqId);
        if (StringUtils.isEmpty((CharSequence)sequenceConfig.getSequenceTemplate())) {
            return sequenceNos;
        }
        HashMap replaceParamMap = MapUtils.newHashMap((int)16);
        if (CollectionUtils.nonEmpty(paramMap)) {
            replaceParamMap.putAll(paramMap);
        }
        String currentDateTimeStr = StringUtils.nonEmpty((CharSequence)((CharSequence)replaceParamMap.get(OPEN_DAY_KEY))) ? AbstractSequence.convertOpenDay((String)replaceParamMap.get(OPEN_DAY_KEY)) : DateUtils.formatDate((String)DateUtils.PATTERN_DATETIME_COMPACT);
        LocalDateTime currentDateTime = LocalDateTime.parse(currentDateTimeStr, DateTimeFormatter.ofPattern(DateUtils.PATTERN_DATETIME_COMPACT));
        replaceParamMap.put("yyyy", String.valueOf(currentDateTime.getYear()));
        replaceParamMap.put("yy", String.valueOf(currentDateTime.getYear()).substring(2));
        replaceParamMap.put("MM", StringUtils.leftPad((String)String.valueOf(currentDateTime.getMonthValue()), (int)2, (String)"0"));
        replaceParamMap.put("dd", StringUtils.leftPad((String)String.valueOf(currentDateTime.getDayOfMonth()), (int)2, (String)"0"));
        replaceParamMap.put("HH", StringUtils.leftPad((String)String.valueOf(currentDateTime.getHour()), (int)2, (String)"0"));
        replaceParamMap.put("mm", StringUtils.leftPad((String)String.valueOf(currentDateTime.getMinute()), (int)2, (String)"0"));
        replaceParamMap.put("ss", StringUtils.leftPad((String)String.valueOf(currentDateTime.getSecond()), (int)2, (String)"0"));
        return sequenceNos.stream().map(sequenceNo -> {
            String fillSequenceNo = AbstractSequence.fillSequenceNo(sequenceNo, sequenceConfig);
            replaceParamMap.put("SEQ", fillSequenceNo);
            replaceParamMap.put("SEQUENCE", fillSequenceNo);
            String sequence = sequenceConfig.getSequenceTemplate();
            for (Map.Entry entry : replaceParamMap.entrySet()) {
                sequence = this.parseParams(sequence, (String)entry.getKey(), (String)entry.getValue());
            }
            return sequence;
        }).collect(Collectors.toList());
    }

    public SequenceIdConverter getSequenceIdConverter() {
        return this.sequenceIdConverter;
    }

    private String parseParams(String sequenceTemplate, String paramName, String paramValue) {
        if (sequenceTemplate.contains("{" + paramName + "}")) {
            return sequenceTemplate.replaceAll("\\{" + paramName + "\\}", paramValue);
        }
        return sequenceTemplate;
    }

    private static String convertOpenDay(String openDay) {
        String convertOpenDay = OPEN_DAY_PATTERN.matcher(openDay).replaceAll("");
        return convertOpenDay.length() == 8 ? StringUtils.builder0((Object[])new Object[]{convertOpenDay, LocalDateTime.now().format(DateTimeFormatter.ofPattern(DateUtils.PATTERN_TIME_COMPACT))}) : convertOpenDay;
    }

    private static String fillSequenceNo(String sequenceNo, SequenceConfig sequenceConfig) {
        if (StringUtils.nonEmpty((CharSequence)sequenceConfig.getFillString())) {
            return StringUtils.leftPad((String)sequenceNo, (int)sequenceConfig.getSeqPlace(), (String)sequenceConfig.getFillString());
        }
        return sequenceNo;
    }

    @Override
    public boolean addSequenceConfig(SequenceConfig sequenceConfig) throws SequenceException {
        Asserts.nonNull((Object)sequenceConfig, (Object[])new Object[]{"Sequence config must not null!"});
        Asserts.nonEmpty((CharSequence)sequenceConfig.getSeqId(), (Object[])new Object[]{"Sequence is must not empty!"});
        String convertSeqId = this.sequenceIdConverter.convert(sequenceConfig.getSeqId());
        if (sequenceConfigMap.containsKey(convertSeqId)) {
            logger.warn("Sequence id:[{}] has exists!", (Object)sequenceConfig.getSeqId());
            return false;
        }
        sequenceConfigMap.put(convertSeqId, sequenceConfig);
        return true;
    }

    @Override
    public boolean dropSequence(String seqId, boolean removeConfig) throws SequenceException {
        if (removeConfig) {
            sequenceConfigMap.remove(seqId);
        }
        return true;
    }

    public List<SequenceConfig> getSequenceConfigs() {
        return Collections.unmodifiableList(new ArrayList<SequenceConfig>(sequenceConfigMap.values()));
    }
}

