/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.rest;

import cn.com.yusys.yusp.commons.ribbon.RouteMappingLocator;
import cn.com.yusys.yusp.commons.ribbon.constant.RequestConstants;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class RouteRestTemplate
extends RestTemplate {
    private RouteMappingLocator routeMappingLocator;

    public RouteRestTemplate() {
    }

    public RouteRestTemplate(RouteMappingLocator routeMappingLocator, List<HttpMessageConverter<?>> converters) {
        super(converters);
        this.routeMappingLocator = routeMappingLocator;
    }

    public RouteMappingLocator getRouteMappingLocator() {
        return this.routeMappingLocator;
    }

    public void setRouteMappingLocator(RouteMappingLocator routeMappingLocator) {
        this.routeMappingLocator = routeMappingLocator;
    }

    protected <T> T doExecute(@NonNull URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
        String serviceId = this.extractServiceId(url);
        url = this.replaceUri(url, serviceId);
        return (T)super.doExecute(url, method, requestCallback, responseExtractor);
    }

    String extractServiceId(URI uri) {
        String originPath = uri.getPath();
        if (uri.getHost() != null) {
            originPath = uri.getHost() + originPath;
        }
        if (!originPath.startsWith(RequestConstants.REQUEST_PATH_SPLIT)) {
            originPath = RequestConstants.REQUEST_PATH_SPLIT + originPath;
        }
        return this.routeMappingLocator.extractServiceId(originPath);
    }

    URI replaceUri(URI uri, String serviceId) {
        if (serviceId != null) {
            StringBuilder originUrl = new StringBuilder(uri.toString());
            int hostBegin = originUrl.indexOf("//");
            if (hostBegin < 0) {
                hostBegin = 0;
                serviceId = "http://" + serviceId;
            } else {
                hostBegin += 2;
            }
            if (originUrl.charAt(hostBegin) != '/') {
                serviceId = serviceId + RequestConstants.REQUEST_PATH_SPLIT;
            }
            originUrl.insert(hostBegin, serviceId);
            return URI.create(originUrl.toString());
        }
        return uri;
    }
}

