/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.enchance;

import cn.com.yusys.yusp.commons.redis.EnhanceRedisCache;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpThreadLocal;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.EnhanceCacheTransactionSynchronization;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class EnhanceCacheDecorator
implements Cache {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceCacheDecorator.class);
    private final ThreadLocal<Map<Object, CacheOpWrapper>> localCaches = new ThreadLocal();
    public static final String CACHE_UPDATE_HOLDER = "@CACHE_UPDATE";
    public static final String EVICT_UPDATE_HOLDER = "@CACHE_EVICT";
    private final EnhanceRedisCache targetCache;

    private void remove() {
        this.localCaches.remove();
    }

    public EnhanceCacheDecorator(Cache targetCache) {
        Assert.notNull((Object)targetCache, (String)"Target Cache must not be null");
        this.targetCache = (EnhanceRedisCache)targetCache;
    }

    public String getName() {
        return this.targetCache.getName();
    }

    public Object getNativeCache() {
        return this.targetCache.getNativeCache();
    }

    public <T> T get(Object key, Class<T> type) {
        Cache.ValueWrapper wrapper = this.get(key);
        return wrapper == null ? null : (T)type.cast(wrapper.get());
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value;
        Cache.ValueWrapper wrapper = this.get(key);
        Object object = value = wrapper == null ? null : wrapper.get();
        if (null == value) {
            try {
                T newValue = valueLoader.call();
                this.put(key, newValue);
                return newValue;
            }
            catch (Exception e) {
                throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
            }
        }
        return (T)value;
    }

    public Cache.ValueWrapper get(Object key) {
        Cache.ValueWrapper wrapper;
        CacheOpWrapper opWrapper;
        Map<Object, CacheOpWrapper> caches;
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            caches = this.registerTransactionSynchronization();
            if (caches.containsKey(key)) {
                CacheOpWrapper value = caches.get(key);
                if (CacheOpWrapper.CacheOpType.REMOVE == value.getCacheOpType()) {
                    return null;
                }
                return value;
            }
        } else {
            caches = this.localCaches.get();
            if (caches == null) {
                caches = new HashMap<Object, CacheOpWrapper>();
                this.localCaches.set(caches);
            }
        }
        if ((opWrapper = this.opWrapper(key, wrapper = this.targetCache.get(key))) == null) {
            return wrapper;
        }
        caches.put(key, opWrapper);
        return null;
    }

    private CacheOpWrapper opWrapper(Object key, Cache.ValueWrapper wrapper) {
        Object value;
        Object object = value = wrapper == null ? null : wrapper.get();
        if (null == value || EnhanceCacheDecorator.isEvict(value)) {
            return CacheOpWrapper.wrapperGet(key, value, true);
        }
        if (EnhanceCacheDecorator.isUpdate(value)) {
            return CacheOpWrapper.wrapperGet(key, value, false);
        }
        return null;
    }

    public void put(Object key, Object value) {
        if (null == value) {
            this.dealMemoryLeak(key);
            return;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Map<Object, CacheOpWrapper> transactionCaches = this.registerTransactionSynchronization();
            CacheOpWrapper cacheOp = transactionCaches.get(key);
            if (cacheOp == null) {
                cacheOp = CacheOpWrapper.wrapperPut(key, value);
                transactionCaches.put(key, cacheOp);
            } else {
                cacheOp.putValue(value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Store put value to transactionCaches[key = {}, value = {}].", key, value);
            }
        } else {
            this.putWithoutTransaction(key, value);
        }
    }

    private void putWithoutTransaction(Object key, Object value) {
        CacheOpWrapper cacheOp;
        CacheOpWrapper cacheOpWrapper = cacheOp = this.localCaches.get() != null ? this.localCaches.get().get(key) : null;
        if (cacheOp == null) {
            this.targetCache.put(key, value);
        } else {
            if (cacheOp.isNeedUpdate()) {
                this.targetCache.put(key, cacheOp.casValue(value));
            } else if (logger.isDebugEnabled()) {
                logger.debug("skip put, key={}, currentValue={}", key, cacheOp.getCurrentValue());
            }
            this.dealMemoryLeak(key);
        }
    }

    private void dealMemoryLeak(Object key) {
        Optional.ofNullable(this.localCaches.get()).ifPresent(map -> map.remove(key));
        if (CacheOpThreadLocal.CacheOps.get().isEmpty()) {
            CacheOpThreadLocal.CacheOps.remove();
        }
    }

    private void removeLocalCache() {
        this.localCaches.remove();
    }

    public void evict(Object key) {
        if (key instanceof Collection) {
            for (Object itemKey : (Collection)key) {
                this.evict(itemKey);
            }
            return;
        }
        String holderValue = RedisUtils.randomPrefix(EVICT_UPDATE_HOLDER);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Map<Object, CacheOpWrapper> transactionCaches = this.registerTransactionSynchronization();
            CacheOpWrapper cacheOp = CacheOpWrapper.wrapperEvict(key, holderValue);
            transactionCaches.put(key, cacheOp);
            if (logger.isDebugEnabled()) {
                logger.debug("Store evict value to transactionCaches[ key = {} ].", key);
            }
        } else {
            this.targetCache.put(key, holderValue);
            if (logger.isDebugEnabled()) {
                logger.debug("Setting evict holder value to cache[ key = {} ].", key);
            }
        }
    }

    public void clear() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Map<Object, CacheOpWrapper> transactionCaches = this.registerTransactionSynchronization();
            CacheOpWrapper cacheOp = CacheOpWrapper.wrapperClear();
            transactionCaches.clear();
            transactionCaches.put(this.getName() + "##clear##", cacheOp);
        } else {
            this.targetCache.clear();
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        this.put(key, value);
        return null;
    }

    public static boolean isUpdate(Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            return strValue.startsWith(CACHE_UPDATE_HOLDER);
        }
        return false;
    }

    public static boolean isEvict(Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            return strValue.startsWith(EVICT_UPDATE_HOLDER);
        }
        return false;
    }

    private Map<Object, CacheOpWrapper> registerTransactionSynchronization() {
        HashMap<Object, CacheOpWrapper> caches = (HashMap<Object, CacheOpWrapper>)TransactionSynchronizationManager.getResource((Object)((Object)this.targetCache));
        if (caches == null) {
            caches = new HashMap<Object, CacheOpWrapper>();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new EnhanceCacheTransactionSynchronization(this.targetCache, caches));
            TransactionSynchronizationManager.bindResource((Object)((Object)this.targetCache), caches);
        }
        return caches;
    }

    protected void onThrowable(Throwable t) {
        logger.warn("Cache operate exception. ", t);
    }
}

