/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EnhanceRedisCacheWriter
implements RedisCacheWriter {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceRedisCacheWriter.class);
    private final RedisConnectionFactory connectionFactory;
    private final Duration sleepTime;
    private static final String NAME_ERROR_DESC = "Name must not be null!";
    private static final String KEY_ERROR_DESC = "Key must not be null!";

    public EnhanceRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, Duration.ZERO);
    }

    public EnhanceRedisCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        Assert.notNull((Object)sleepTime, (String)"SleepTime must not be null!");
        this.connectionFactory = connectionFactory;
        this.sleepTime = sleepTime;
    }

    public void put(String name, byte[] key, byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)NAME_ERROR_DESC);
        Assert.notNull((Object)key, (String)KEY_ERROR_DESC);
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(connection -> {
            if (EnhanceRedisCacheWriter.shouldExpireWithin(ttl)) {
                connection.set(key, value, Expiration.from((long)ttl.getSeconds(), (TimeUnit)TimeUnit.SECONDS), RedisStringCommands.SetOption.upsert());
            } else {
                connection.set(key, value);
            }
            return "OK";
        });
    }

    public void casPut(String name, byte[] scriptsha, byte[] script, @Nullable Duration ttl, byte[] ... keysAndArgs) {
        Assert.notNull((Object)name, (String)NAME_ERROR_DESC);
        Assert.notNull((Object)script, (String)"Lua Script must not be null!");
        Assert.notNull((Object)keysAndArgs, (String)"KeysAndArgs must not be null!");
        this.execute(connection -> {
            block3: {
                try {
                    connection.evalSha(scriptsha, ReturnType.VALUE, 1, keysAndArgs);
                    if (EnhanceRedisCacheWriter.shouldExpireWithin(ttl)) {
                        connection.pExpire(keysAndArgs[0], ttl.toMillis());
                    }
                }
                catch (Exception e) {
                    logger.debug("Can't evalSha cache [name = {}], [script = {}] , [keysAndArgs = {}]; Exception message: {}", new Object[]{name, script, keysAndArgs, e.getMessage()});
                    connection.eval(script, ReturnType.VALUE, 1, keysAndArgs);
                    if (!EnhanceRedisCacheWriter.shouldExpireWithin(ttl)) break block3;
                    connection.pExpire(keysAndArgs[0], ttl.toMillis());
                }
            }
            return "OK";
        });
    }

    public byte[] get(String name, byte[] key) {
        Assert.notNull((Object)name, (String)NAME_ERROR_DESC);
        Assert.notNull((Object)key, (String)KEY_ERROR_DESC);
        return this.execute(connection -> connection.get(key));
    }

    public byte[] putIfAbsent(String name, byte[] key, byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)NAME_ERROR_DESC);
        Assert.notNull((Object)key, (String)KEY_ERROR_DESC);
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.execute(connection -> {
            if (connection.setNX(key, value).booleanValue()) {
                if (EnhanceRedisCacheWriter.shouldExpireWithin(ttl)) {
                    connection.pExpire(key, ttl.toMillis());
                }
                return null;
            }
            return connection.get(key);
        });
    }

    public void remove(String name, byte[] key) {
        Assert.notNull((Object)name, (String)NAME_ERROR_DESC);
        Assert.notNull((Object)key, (String)KEY_ERROR_DESC);
        this.execute(connection -> connection.del((byte[][])new byte[][]{key}));
    }

    public void clean(String name, byte[] pattern) {
        Assert.notNull((Object)name, (String)NAME_ERROR_DESC);
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        this.execute(connection -> {
            byte[][] keys = (byte[][])Optional.ofNullable(connection.keys(pattern)).orElse(Collections.emptySet()).toArray((T[])new byte[0][]);
            if (keys.length > 0) {
                connection.del(keys);
            }
            return "OK";
        });
    }

    public void clearStatistics(String name) {
        logger.warn("===========clearStatistics===TODO");
    }

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector cacheStatisticsCollector) {
        logger.warn("===========withStatisticsCollector===TODO");
        return new EnhanceRedisCacheWriter(this.connectionFactory);
    }

    void lock(String name) {
        this.execute(connection -> this.doLock(name, (RedisConnection)connection));
    }

    void unlock(String name) {
        this.executeLockFree(connection -> this.doUnlock(name, (RedisConnection)connection));
    }

    private Boolean doLock(String name, RedisConnection connection) {
        return connection.setNX(EnhanceRedisCacheWriter.createCacheLockKey(name), new byte[0]);
    }

    private Long doUnlock(String name, RedisConnection connection) {
        return connection.del((byte[][])new byte[][]{EnhanceRedisCacheWriter.createCacheLockKey(name)});
    }

    boolean doCheckLock(String name, RedisConnection connection) {
        return connection.exists(EnhanceRedisCacheWriter.createCacheLockKey(name));
    }

    private boolean isLockingCacheWriter() {
        return !this.sleepTime.isZero() && !this.sleepTime.isNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Function<RedisConnection, T> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            T t = callback.apply(connection);
            return t;
        }
    }

    private void executeLockFree(Consumer<RedisConnection> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            callback.accept(connection);
        }
    }

    private void checkAndPotentiallyWaitUntilUnlocked(String name, RedisConnection connection) {
        if (!this.isLockingCacheWriter()) {
            return;
        }
        try {
            while (this.doCheckLock(name, connection)) {
                Thread.sleep(this.sleepTime.toMillis());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PessimisticLockingFailureException(String.format("Interrupted while waiting to unlock cache %s", name), (Throwable)ex);
        }
    }

    private static boolean shouldExpireWithin(@Nullable Duration ttl) {
        return ttl != null && !ttl.isZero() && !ttl.isNegative();
    }

    private static byte[] createCacheLockKey(String name) {
        return (name + "~lock").getBytes(StandardCharsets.UTF_8);
    }

    public CacheStatistics getCacheStatistics(String cacheName) {
        logger.warn("===========getCacheStatistics===TODO");
        return null;
    }
}

