/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.enchance;

import cn.com.yusys.yusp.commons.redis.enchance.CasValueWrapper;
import org.springframework.cache.Cache;

public class CacheOpWrapper
implements Cache.ValueWrapper {
    private final Object key;
    private CacheOpType cacheOpType;
    private Object value;
    private Object currentValue;
    private boolean needUpdate = true;

    public static CacheOpWrapper wrapperGet(Object key, Object currentValue, boolean needUpdate) {
        CacheOpWrapper wrapper = new CacheOpWrapper(key, CacheOpType.READ);
        wrapper.currentValue = currentValue;
        wrapper.needUpdate = needUpdate;
        return wrapper;
    }

    public static CacheOpWrapper wrapperPut(Object key, Object newValue) {
        CacheOpWrapper wrapper = new CacheOpWrapper(key, CacheOpType.WRITE);
        wrapper.value = newValue;
        return wrapper;
    }

    public static CacheOpWrapper wrapperEvict(Object key, Object flagValue) {
        CacheOpWrapper wrapper = new CacheOpWrapper(key, CacheOpType.REMOVE);
        wrapper.value = flagValue;
        return wrapper;
    }

    public static CacheOpWrapper wrapperClear() {
        return new CacheOpWrapper(null, CacheOpType.CLEAR);
    }

    private CacheOpWrapper(Object key, CacheOpType cacheOpType) {
        this.key = key;
        this.cacheOpType = cacheOpType;
    }

    public void putValue(Object newValue) {
        this.cacheOpType = this.cacheOpType == CacheOpType.READ ? CacheOpType.READ_WRITE : CacheOpType.WRITE;
        this.value = newValue;
    }

    public CacheOpType getCacheOpType() {
        return this.cacheOpType;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(Object currentValue) {
        this.currentValue = currentValue;
    }

    public Object get() {
        if (this.value instanceof Cache.ValueWrapper) {
            return ((Cache.ValueWrapper)this.value).get();
        }
        return this.value;
    }

    public CasValueWrapper casValue() {
        return this.casValue(this.get());
    }

    public CasValueWrapper casValue(Object newValue) {
        return CasValueWrapper.of(this.currentValue).newValue(newValue);
    }

    public static enum CacheOpType {
        READ,
        READ_WRITE,
        WRITE,
        REMOVE,
        CLEAR;

    }
}

