/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.connection;

import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.redis.connection.EnhanceJedisClusterConnection;
import java.lang.reflect.Field;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.JedisCluster;

public class EnhanceJedisConnectionFactory
extends JedisConnectionFactory {
    public EnhanceJedisConnectionFactory() {
    }

    public EnhanceJedisConnectionFactory(RedisClusterConfiguration clusterConfig, JedisClientConfiguration clientConfig) {
        super(clusterConfig, clientConfig);
    }

    public EnhanceJedisConnectionFactory(RedisSentinelConfiguration sentinelConfig, JedisClientConfiguration clientConfig) {
        super(sentinelConfig, clientConfig);
    }

    public EnhanceJedisConnectionFactory(RedisStandaloneConfiguration standaloneConfig, JedisClientConfiguration clientConfig) {
        super(standaloneConfig, clientConfig);
    }

    public RedisClusterConnection getClusterConnection() {
        if (!this.isRedisClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        return new EnhanceJedisClusterConnection(this.getJedisCluster(), this.getClusterCommandExecutor());
    }

    private JedisCluster getJedisCluster() {
        JedisCluster cluster = null;
        try {
            Field field = JedisConnectionFactory.class.getDeclaredField("cluster");
            ReflectionUtils.makeAccessible((Field)field);
            cluster = (JedisCluster)ReflectionUtils.getField((Field)field, (Object)((Object)this));
        }
        catch (Exception e) {
            throw new PlatformException("getJedisCluster error.", (Throwable)e);
        }
        return cluster;
    }

    private ClusterCommandExecutor getClusterCommandExecutor() {
        ClusterCommandExecutor clusterCommandExecutor;
        try {
            Field field = JedisConnectionFactory.class.getDeclaredField("clusterCommandExecutor");
            ReflectionUtils.makeAccessible((Field)field);
            clusterCommandExecutor = (ClusterCommandExecutor)ReflectionUtils.getField((Field)field, (Object)((Object)this));
        }
        catch (Exception e) {
            throw new PlatformException("getClusterCommandExecutor error.", (Throwable)e);
        }
        return clusterCommandExecutor;
    }
}

