/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.pdf.adapter;

import cn.com.yusys.yusp.commons.pdf.adapter.STSongFont;
import cn.com.yusys.yusp.commons.util.RandomUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import com.itextpdf.text.Document;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

public class PdfUtil {
    private static XMLWorkerHelper worker = XMLWorkerHelper.getInstance();

    public static File getPdfFileByTemplate(String template, Map<String, Object> data) throws Exception {
        Context c = new Context();
        c.setVariables(data);
        StringWriter stringWriter = new StringWriter();
        SpringTemplateEngine springTemplateEngine = (SpringTemplateEngine)SpringContextUtils.getBean(SpringTemplateEngine.class);
        springTemplateEngine.process(template, (IContext)c, (Writer)stringWriter);
        String htmlStr = stringWriter.toString();
        String filePath = System.getProperty("java.io.tmpdir");
        String fileName = filePath + File.separator + RandomUtils.randomString((int)16) + ".pdf";
        FileOutputStream pdf = new FileOutputStream(fileName);
        Document document = null;
        try {
            document = new Document(PageSize.A4);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)pdf);
            document.open();
            worker.parseXHtml(pdfWriter, document, (InputStream)new ByteArrayInputStream(htmlStr.getBytes("UTF-8")), null, Charset.forName("UTF-8"), (FontProvider)new STSongFont());
            File file = new File(fileName);
            return file;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            if (null != document) {
                document.close();
            }
        }
    }
}

