/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.sender;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

class OpLogFilter {
    private static final Logger logger = LoggerFactory.getLogger(OpLogFilter.class);
    private final Set<String> urlFormats;
    private final Set<String> ignoreUrlFormats;
    private AntPathMatcher matcher = new AntPathMatcher();

    public OpLogFilter(Set<String> urlFormats, Set<String> ignoreUrlFormats) {
        this.urlFormats = urlFormats;
        this.ignoreUrlFormats = ignoreUrlFormats;
    }

    public boolean match(String url) {
        boolean match = false;
        if (null == this.ignoreUrlFormats) {
            match = true;
        } else {
            boolean bl = match = !this.ignoreMatch(url);
        }
        if (match && null != this.urlFormats) {
            match = this.defaultMatch(url);
        }
        if (!match && logger.isDebugEnabled()) {
            logger.debug("[op log] no hit url:{}", (Object)url);
        }
        return match;
    }

    private boolean defaultMatch(String url) {
        if (null != this.urlFormats) {
            for (String urlFormat : this.urlFormats) {
                if (!this.matcher.match(urlFormat, url)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("[op log] hit url:{}", (Object)url);
                }
                return true;
            }
        }
        return false;
    }

    private boolean ignoreMatch(String url) {
        for (String urlFormat : this.ignoreUrlFormats) {
            if (!this.matcher.match(urlFormat, url)) continue;
            return true;
        }
        return false;
    }
}

