/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.sender;

import cn.com.yusys.yusp.commons.oplog.oplog.ILogSave;
import cn.com.yusys.yusp.commons.oplog.sender.LogData;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class OnlineLogBatchUpload
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineLogBatchUpload.class);
    private static LinkedBlockingQueue<LogData> queue = new LinkedBlockingQueue(1000000);
    private final int batchSize;
    private final Thread sendThread;
    private volatile boolean running = false;
    private ILogSave iLogSave;

    public OnlineLogBatchUpload(ILogSave iLogSave, int batchSize) {
        this.iLogSave = iLogSave;
        this.batchSize = batchSize;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("OnlineLog-Sender-Thread").build();
        this.sendThread = threadFactory.newThread(new SendThread(batchSize));
        this.sendThread.setDaemon(true);
        this.sendThread.setName("OnlineLog-Sender-Thread");
    }

    public void addLog(LogData logData) {
        if (!queue.offer(logData)) {
            LOG.error("online log queue is full, unsend log: {}", logData.getData());
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.running = true;
        this.sendThread.start();
        LOG.info("OnlineLog thread started.");
    }

    public void destroy() throws Exception {
        this.running = false;
        this.sendThread.interrupt();
    }

    private class SendThread
    implements Runnable {
        private final Logger LOG = LoggerFactory.getLogger(SendThread.class);
        private final ArrayList<Object> buffer;
        private String bufferName = null;

        public SendThread(int batchSize) {
            this.buffer = new ArrayList(batchSize);
        }

        @Override
        public void run() {
            while (OnlineLogBatchUpload.this.running) {
                try {
                    this.doUpdateData();
                }
                catch (InterruptedException e) {
                    if (OnlineLogBatchUpload.this.running) {
                        this.LOG.error("OnlineLog thread interrupted.", (Throwable)e);
                        continue;
                    }
                    Thread.currentThread().interrupt();
                }
            }
            this.LOG.info("OnlineLog thread stopped.");
        }

        private void doUpdateData() throws InterruptedException {
            LogData logData;
            if (!this.buffer.isEmpty()) {
                OnlineLogBatchUpload.this.iLogSave.save(this.bufferName, this.buffer);
                this.buffer.clear();
            }
            if ((logData = (LogData)queue.take()) != null) {
                this.bufferName = logData.getQueueName();
                this.buffer.add(logData.getData());
                while ((logData = (LogData)queue.poll()) != null) {
                    if (this.buffer.size() >= OnlineLogBatchUpload.this.batchSize || !logData.getQueueName().equals(this.bufferName)) {
                        OnlineLogBatchUpload.this.iLogSave.save(this.bufferName, this.buffer);
                        this.buffer.clear();
                        this.bufferName = logData.getQueueName();
                    }
                    this.buffer.add(logData.getData());
                }
                if (!this.buffer.isEmpty()) {
                    OnlineLogBatchUpload.this.iLogSave.save(this.bufferName, this.buffer);
                    this.buffer.clear();
                }
            }
        }
    }
}

