/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.save;

import cn.com.yusys.yusp.commons.module.domain.DomainHelper;
import cn.com.yusys.yusp.commons.oplog.oplog.ILogSave;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.util.ObjectUtils;

public class RabbitLogSave
implements ILogSave {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitLogSave.class);
    private RabbitTemplate rabbitTemplate;

    public RabbitLogSave(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void save(String typeName, List<Object> data) {
        if (ObjectUtils.isEmpty(data)) {
            return;
        }
        LOG.debug("send online log:{}.", data);
        try {
            MessageProperties properties = new MessageProperties();
            Map headers = properties.getHeaders();
            headers.put("log-request-ip", InetAddress.getLocalHost().getHostAddress());
            headers.put("log-request-app", DomainHelper.currentAppName());
            Message message = this.rabbitTemplate.getMessageConverter().toMessage(data, properties);
            this.rabbitTemplate.convertAndSend(typeName, (Object)message);
        }
        catch (UnknownHostException e) {
            LOG.debug("Send OpLog failure.", (Throwable)e);
        }
    }
}

