/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.sender;

import cn.com.yusys.yusp.commons.biz.bizlog.BizExceptionLog;
import cn.com.yusys.yusp.commons.biz.bizlog.IBizExceptionLogSender;
import cn.com.yusys.yusp.commons.oplog.sender.LogData;
import cn.com.yusys.yusp.commons.oplog.sender.OnlineLogBatchUpload;
import cn.com.yusys.yusp.commons.oplog.util.OnlineLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BizLogSender
implements IBizExceptionLogSender {
    private static final Logger LOG = LoggerFactory.getLogger(BizLogSender.class);
    private final OnlineLogBatchUpload logUpload;

    public BizLogSender(OnlineLogBatchUpload logUpload) {
        this.logUpload = logUpload;
    }

    public void send(BizExceptionLog data) {
        if (StringUtils.isEmpty((Object)data.getInputOperNum())) {
            OnlineLogUtils.fillContextInfo(data, true);
        }
        LOG.warn("BizExceptionLog: funcNum={}, tradeNum={}, desc={}", new Object[]{data.getFuncNum(), data.getBizTradeNum(), data.getExcepDesc()});
        this.logUpload.addLog(new LogData("online-bizlog", data));
    }
}

