/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.listener;

import cn.com.yusys.yusp.commons.biz.bizlog.BizExceptionLog;
import cn.com.yusys.yusp.commons.biz.bizlog.IBizExceptionLogProcessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

public class BizLogListener {
    private static final Logger log = LoggerFactory.getLogger(BizLogListener.class);
    private final IBizExceptionLogProcessor logProcess;

    public BizLogListener(IBizExceptionLogProcessor logProcess) {
        this.logProcess = logProcess;
    }

    @RabbitHandler
    @RabbitListener(queues={"online-bizlog"}, containerFactory="logRabbitListener")
    public void process(List<BizExceptionLog> dto, Message message) {
        if (log.isDebugEnabled()) {
            Map headers = message.getMessageProperties().getHeaders();
            log.debug("processing biz ex log, size:{}, from app:{}, ip:{},OpLog function:{}.", new Object[]{dto.size(), headers.get("log-request-app"), headers.get("log-request-ip"), dto.stream().map(BizExceptionLog::getFuncNum).collect(Collectors.joining(","))});
        }
        this.logProcess.process(dto);
    }
}

