/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.sender;

import cn.com.yusys.yusp.commons.module.domain.DomainHelper;
import cn.com.yusys.yusp.commons.oplog.sender.LogData;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class OnlineLogBatchUpload
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineLogBatchUpload.class);
    private static LinkedBlockingQueue<LogData> queue = new LinkedBlockingQueue(1000000);
    private final int batchSize;
    private final RabbitTemplate rabbitTemplate;
    private final Thread sendThread;
    private volatile boolean running = false;

    public OnlineLogBatchUpload(RabbitTemplate rabbitTemplate, int batchSize) {
        this.rabbitTemplate = rabbitTemplate;
        this.batchSize = batchSize;
        this.sendThread = new Thread(new SendThread(batchSize));
        this.sendThread.setDaemon(true);
        this.sendThread.setName("OnlineLog-Sender-Thread");
    }

    public void addLog(LogData logData) {
        if (!queue.offer(logData)) {
            LOG.error("online log queue is full, unsend log: {}", logData.getData());
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.running = true;
        this.sendThread.start();
        LOG.info("OnlineLog thread started.");
    }

    public void destroy() throws Exception {
        this.running = false;
        this.sendThread.interrupt();
    }

    private class SendThread
    implements Runnable {
        private final ArrayList<Object> buffer;
        private String bufferQueueName = null;

        public SendThread(int batchSize) {
            this.buffer = new ArrayList(batchSize);
        }

        @Override
        public void run() {
            while (OnlineLogBatchUpload.this.running) {
                try {
                    this.doUpdateData();
                }
                catch (InterruptedException e) {
                    if (OnlineLogBatchUpload.this.running) {
                        LOG.error("OnlineLog thread interrupted.", (Throwable)e);
                        continue;
                    }
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info("OnlineLog thread stopped.");
        }

        private void doUpdateData() throws InterruptedException {
            LogData logData;
            if (!this.buffer.isEmpty()) {
                this.send(this.buffer);
                this.buffer.clear();
            }
            if ((logData = (LogData)queue.poll(10L, TimeUnit.SECONDS)) != null) {
                this.bufferQueueName = logData.getQueueName();
                this.buffer.add(logData.getData());
                while ((logData = (LogData)queue.poll()) != null) {
                    if (this.buffer.size() == OnlineLogBatchUpload.this.batchSize || !logData.getQueueName().equals(this.bufferQueueName)) {
                        this.send(this.buffer);
                        this.buffer.clear();
                        this.bufferQueueName = logData.getQueueName();
                    }
                    this.buffer.add(logData.getData());
                }
                this.send(this.buffer);
                this.buffer.clear();
            }
        }

        void send(List<Object> data) {
            if (CommonUtils.isNullOrEmpty(data)) {
                return;
            }
            LOG.debug("send online log:{}.", data);
            try {
                MessageProperties properties = new MessageProperties();
                Map headers = properties.getHeaders();
                headers.put("log-request-ip", InetAddress.getLocalHost().getHostAddress());
                headers.put("log-request-app", DomainHelper.currentAppName());
                Message message = OnlineLogBatchUpload.this.rabbitTemplate.getMessageConverter().toMessage(data, properties);
                OnlineLogBatchUpload.this.rabbitTemplate.convertAndSend(this.bufferQueueName, (Object)message);
            }
            catch (UnknownHostException e) {
                LOG.debug("Send OpLog failure.", (Throwable)e);
            }
        }
    }
}

