/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.service;

import cn.com.yusys.yusp.notification.api.AbstractNotificationPush;
import cn.com.yusys.yusp.notification.api.NotificationeInfo;

public class NotificationPushService
extends AbstractNotificationPush {
    @Override
    public void publishMember(String memberCode, NotificationeInfo notificationInfo, int expiredSecond) {
        String memTopic = this.dbService.getMemberTopicName(memberCode);
        this.publishInternal(memTopic, notificationInfo, expiredSecond);
    }

    @Override
    public void publish(String topicName, NotificationeInfo notificationInfo, int expiredSecond) {
        this.publishInternal(topicName, notificationInfo, expiredSecond);
    }

    @Override
    public void broadcastPublish(NotificationeInfo notificationInfo, int expiredSecond) {
        String memTopic = this.dbService.getMemberTopicName("BROADCAST");
        this.publishInternal(memTopic, notificationInfo, expiredSecond);
    }

    @Override
    public String sendMessage(String consumerId, NotificationeInfo notificationInfo) {
        String notificationListKey = this.dbService.getNotificationListKey(consumerId);
        String notification = notificationInfo.getPayload();
        this.redisOperation.set(notificationListKey, Integer.toString(notification.hashCode()), notification, 43200);
        this.notifyConsumer(consumerId, "", "M-");
        return "success";
    }

    private void publishInternal(String topicName, NotificationeInfo notification, int expiredSecond) {
        if (expiredSecond <= 0) {
            expiredSecond = 43200;
        }
        this.redisOperation.set(this.dbService.getNextNotificationKey(topicName), notification.getPayload(), expiredSecond);
        this.dbService.incrementGlobal(topicName);
    }
}

