DROP TABLE "NOTIFICATION_TOPIC_SUBSCRIBE";
CREATE TABLE "NOTIFICATION_TOPIC_SUBSCRIBE"
(
    "TOPIC_ID"         NUMBER(25)         NOT NULL,
    "TOPIC_NAME"       VARCHAR2(128 BYTE) NULL,
    "OPER_NUM"         VARCHAR2(128 BYTE) NULL,
    "LAST_UPDATE_TIME" DATE               NULL
)
    LOGGING
    NOCOMPRESS
    NOCACHE
;
COMMENT ON TABLE "NOTIFICATION_TOPIC_SUBSCRIBE" IS '主题订阅表';
COMMENT ON COLUMN "NOTIFICATION_TOPIC_SUBSCRIBE"."TOPIC_ID" IS '主题ID';
COMMENT ON COLUMN "NOTIFICATION_TOPIC_SUBSCRIBE"."TOPIC_NAME" IS '主题名称';
COMMENT ON COLUMN "NOTIFICATION_TOPIC_SUBSCRIBE"."OPER_NUM" IS '操作员编号';
COMMENT ON COLUMN "NOTIFICATION_TOPIC_SUBSCRIBE"."LAST_UPDATE_TIME" IS '最后更新日期';

-- ----------------------------
-- Indexes structure for table NOTIFICATION_TOPIC_SUBSCRIBE
-- ----------------------------
CREATE INDEX "IDX_TOPIC_NAME"
    ON "NOTIFICATION_TOPIC_SUBSCRIBE" ("TOPIC_NAME" ASC)
    LOGGING
    VISIBLE;

-- ----------------------------
-- Checks structure for table NOTIFICATION_TOPIC_SUBSCRIBE
-- ----------------------------
ALTER TABLE "NOTIFICATION_TOPIC_SUBSCRIBE"
    ADD CHECK ("TOPIC_ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table NOTIFICATION_TOPIC_SUBSCRIBE
-- ----------------------------
ALTER TABLE "NOTIFICATION_TOPIC_SUBSCRIBE"
    ADD PRIMARY KEY ("TOPIC_ID");
