/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.service;

import cn.com.yusys.yusp.notification.domain.NotificationTopicSubscribe;
import cn.com.yusys.yusp.notification.repo.DbOperation;
import cn.com.yusys.yusp.notification.service.AbstractNotificationService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class NotificationDbService
extends AbstractNotificationService {
    @Lazy
    @Autowired
    private DbOperation dbOperation;

    @Override
    public void subscribeAppend(String consumerId, String topicName, String lastIndex) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("topicName", topicName);
        paramsMap.put("operNum", consumerId);
        List<NotificationTopicSubscribe> list = this.dbOperation.selectAll(paramsMap);
        if (list == null || list.isEmpty()) {
            NotificationTopicSubscribe record = new NotificationTopicSubscribe();
            record.setTopicName(topicName);
            record.setOperNum(consumerId);
            record.setLastUpdateTime(new Date());
            this.dbOperation.insertSelective(record);
        }
        this.redisOperation.setIfAbsent(subscribeKey, topicName, lastIndex);
    }

    @Override
    public void unSubscribeAppend(String consumerId, String topicName) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        this.redisOperation.delete(subscribeKey, topicName);
        this.dbOperation.deleteByTopicNameAndOperNum(topicName, consumerId);
    }

    @Override
    public void unSubscribeAppend(String consumerId) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        Map<String, String> topicMap = this.redisOperation.getHash(subscribeKey);
        topicMap.forEach((k, v) -> {
            if (this.notInnerKey((String)k)) {
                this.redisOperation.delete(subscribeKey, (String)k);
            }
        });
        this.dbOperation.deleteByOperNum(consumerId);
    }
}

