/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.service;

import cn.com.yusys.yusp.commons.util.NetUtils;
import cn.com.yusys.yusp.commons.util.RandomUtils;
import cn.com.yusys.yusp.notification.repo.RedisOperation;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractNotificationService {
    public static final String TOPIC_KEY_PREFIX = "[PHTP]:";
    public static final String EVENT_LIST_KEY_PREFIX = "[PHEL]:";
    public static final String NOTIFICATION_LIST_KEY_PREFIX = "[PHML]:";
    public static final String GLOBAL_INDEX_KEY = "[GLOBAL]:MSG";
    public static final String HOST_INDEX_FIELD = "--##HOST##--";
    public static final String MEMBER_TOPIC_PREFIX = "--##MEM##--";
    public static final String TOPIC_KEY_BROADCAST = "BROADCAST";
    public static final String NOTIFY_TYPE_NOTIFICATION = "M-";
    public static final String NOTIFY_TYPE_SUBSCRIBE = "S-";
    public static final String NOTIFY_TYPE_UNSUBSCRIBE = "U-";
    public static final String DELI = "@@@@";
    public static final String SUBSCRIBE_KEY_PREFIX = "[PHCU]:";
    public static final String CLIENTID = "cid";
    public static final String GW_IP = "gwip";
    @Autowired
    protected RedisOperation redisOperation;
    private String hostAddr;
    @Value(value="${server.port:8080}")
    private int protocolPort;

    public Map<String, String> getSubscribing(String consumerId) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        Map<String, String> result = this.redisOperation.getHash(subscribeKey);
        result.remove(HOST_INDEX_FIELD);
        return result;
    }

    public String getNotificationListKey(String consumerId) {
        return NOTIFICATION_LIST_KEY_PREFIX + consumerId;
    }

    public String getEventListKey(String hostName) {
        return EVENT_LIST_KEY_PREFIX + hostName;
    }

    public String getMemberTopicName(String memCode) {
        return MEMBER_TOPIC_PREFIX + memCode;
    }

    public String getSubscribeKey(String consumerId) {
        return SUBSCRIBE_KEY_PREFIX + consumerId;
    }

    public String getTopicIndex(String topicName) {
        String topicIndexKey = this.getTopicIndexKey(topicName);
        String topicIndex = this.redisOperation.get(topicIndexKey);
        return topicIndex == null ? "0" : topicIndex;
    }

    public String getTopicIndexKey(String topicName) {
        return TOPIC_KEY_PREFIX + topicName + ":INDEX";
    }

    public String getTopicKey(String topicName) {
        return TOPIC_KEY_PREFIX + topicName;
    }

    public String getNotificationKey(String topicName, Long index) {
        return TOPIC_KEY_PREFIX + topicName + ":" + index.toString();
    }

    public boolean notInnerKey(String key) {
        return !key.startsWith("--##");
    }

    public String getNextNotificationKey(String topicName) {
        String topicIndexKey = this.getTopicIndexKey(topicName);
        Long nextIndex = this.redisOperation.increment(topicIndexKey);
        return this.getNotificationKey(topicName, nextIndex);
    }

    public abstract void subscribeAppend(String var1, String var2, String var3);

    public abstract void unSubscribeAppend(String var1, String var2);

    public abstract void unSubscribeAppend(String var1);

    public void updateOnlineHost(String consumerId) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        this.redisOperation.set(subscribeKey, HOST_INDEX_FIELD, this.getHostAddress());
    }

    public String getOnlineHost(String consumerId) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        return this.redisOperation.get(subscribeKey, HOST_INDEX_FIELD);
    }

    public void incrementGlobal(String topicName) {
        long key = this.redisOperation.increment(GLOBAL_INDEX_KEY);
        this.redisOperation.set(GLOBAL_INDEX_KEY + key, topicName, 3600);
    }

    public String getGlobalMsg(long key) {
        return this.redisOperation.get(GLOBAL_INDEX_KEY + key);
    }

    public String getSubscribeIndex(String consumerId, String topicName) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        return this.redisOperation.get(subscribeKey, topicName);
    }

    public Set<String> getSubscribingTopics(String consumerId) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        return this.redisOperation.fields(subscribeKey).stream().filter(this::notInnerKey).collect(Collectors.toSet());
    }

    public Long getGlobalIndex() {
        String index = this.redisOperation.get(GLOBAL_INDEX_KEY);
        if (index != null) {
            return Long.parseLong(index);
        }
        return 0L;
    }

    public String popEventNotification(int timeout, String hostName) {
        String eventListKey = this.getEventListKey(hostName);
        return this.redisOperation.rpop(timeout, eventListKey);
    }

    public Map<Long, String> getNotifications(String topicName, Long startIndex, Long endIndex) {
        HashMap<Long, String> notificationMap = new HashMap<Long, String>(16);
        Long index = startIndex + 1L;
        while (index <= endIndex) {
            this.getNotifications(topicName, index, notificationMap);
            Long l = index;
            Long l2 = index = Long.valueOf(index + 1L);
        }
        return notificationMap;
    }

    public String getNotifications(String topicName, Long index, Map<Long, String> notificationMap) {
        String msgKey;
        String notification = notificationMap.get(index);
        if (notification == null && (notification = this.redisOperation.get(msgKey = this.getNotificationKey(topicName, index))) != null) {
            notificationMap.putIfAbsent(index, notification);
        }
        return notification;
    }

    public Map<String, String> getSendNotifications(String consumerId) {
        String notificationListKey = this.getNotificationListKey(consumerId);
        return this.redisOperation.getHash(notificationListKey);
    }

    public void removeSendNotification(String consumerId, String field) {
        String notificationListKey = this.getNotificationListKey(consumerId);
        this.redisOperation.delete(notificationListKey, field);
    }

    public Boolean updateSubscribeIndex(String consumerId, String topicName, Long index) {
        String subscribeKey = this.getSubscribeKey(consumerId);
        return this.redisOperation.setIfExists(subscribeKey, topicName, index.toString());
    }

    public String getHostAddress() {
        if (this.hostAddr == null) {
            InetAddress inetAddress = NetUtils.getLocalAddress();
            this.hostAddr = inetAddress != null && NetUtils.isValidAddress((InetAddress)inetAddress) ? inetAddress.getHostAddress() + ":" + this.protocolPort : RandomUtils.getRandom((int)9);
        }
        return this.hostAddr;
    }
}

