/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.injector;

import cn.com.yusys.yusp.commons.mybatisplus.annotation.TableIdEx;
import cn.com.yusys.yusp.commons.mybatisplus.injector.DefaultSqlInjectorExtension;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ITableIdExtension {
    default public List<TableFieldInfo> getTableIdExFields(Class<?> modelClass, TableInfo tableInfo) {
        return DefaultSqlInjectorExtension.TABLE_ID_EX_CACHE.computeIfAbsent(modelClass, c -> Stream.of(c.getDeclaredFields()).filter(f -> f.isAnnotationPresent(TableIdEx.class)).sorted(Comparator.comparingInt(f -> f.getAnnotation(TableIdEx.class).value())).map(f -> tableInfo.getFieldList().stream().filter(tfi -> tfi.getProperty().equals(f.getName())).findAny().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    default public String appendAndCreateExSql(List<TableFieldInfo> exList, SqlMethod sqlMethod, List<Object> formatArgs) {
        String suffix = "</script>";
        boolean appendSuffix = false;
        StringBuilder sqlBuilder = new StringBuilder(sqlMethod.getSql());
        if (sqlMethod.getSql().endsWith(suffix)) {
            sqlBuilder.setLength(sqlBuilder.length() - suffix.length());
            appendSuffix = true;
        }
        int idx = 1;
        for (TableFieldInfo tfi : exList) {
            this.processExField(tfi, idx, sqlBuilder, formatArgs);
            ++idx;
        }
        if (appendSuffix) {
            sqlBuilder.append(suffix);
        }
        return String.format(sqlBuilder.toString(), formatArgs.toArray());
    }

    default public void processExField(TableFieldInfo tfi, int idx, StringBuilder sqlBuilder, List<Object> formatArgs) {
        sqlBuilder.append(" AND %s=#{array[");
        sqlBuilder.append(idx);
        sqlBuilder.append("]}");
        formatArgs.add(tfi.getColumn());
    }
}

