/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.conditions;

import cn.com.yusys.yusp.commons.mybatisplus.conditions.EntityQueryObjectWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;

public abstract class EntityQueryObject<T> {
    private static final Type BEAN_TYPE_SELF = Type.getType(EntityQueryObject.class);
    protected Object queryObject;
    private List<Order> orderInfo = new ArrayList<Order>();

    public static <T> EntityQueryObject<T> create(Object queryObject, Class<T> entityClass) {
        Objects.requireNonNull(queryObject, "Query object is must not null!");
        Generator gen = new Generator(entityClass, queryObject.getClass());
        EntityQueryObject target = gen.create();
        target.queryObject = queryObject;
        return target;
    }

    public LambdaQueryWrapper<T> buildWrapper() {
        return this.buildWrapper(null);
    }

    public LambdaQueryWrapper<T> buildWrapper(Consumer<LambdaQueryWrapper<T>> wrapperIniter) {
        EntityQueryObjectWrapper wrapper = new EntityQueryObjectWrapper();
        if (Objects.nonNull(wrapperIniter)) {
            wrapperIniter.accept(wrapper);
        }
        return this.orderBy(this.processWrapper(wrapper));
    }

    public LambdaQueryWrapper<T> orderBy(EntityQueryObjectWrapper<T> wrapper) {
        this.orderInfo.stream().filter(o -> o.orderValue != 0).sorted(Comparator.comparingInt(o -> ((Order)o).absOrderValue())).forEach(o -> wrapper.orderBy(o.orderValue >= 0, o.columnName));
        return wrapper;
    }

    protected void cacheOrderInfo(int orderValue, String columnName) {
        Order order = new Order();
        order.orderValue = orderValue;
        order.columnName = columnName;
        this.orderInfo.add(order);
    }

    protected abstract EntityQueryObject<T> newInstance();

    protected abstract EntityQueryObjectWrapper<T> processWrapper(EntityQueryObjectWrapper<T> var1);

    private static class Generator<T>
    extends AbstractClassGenerator<EntityQueryObject<T>> {
        private static final EntityQueryObjectKey KEY_FACTORY = (EntityQueryObjectKey)KeyFactory.create(EntityQueryObjectKey.class);
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(EntityQueryObject.class.getName());
        private static final Type TYPE_ENTITY_WRAPPER = Type.getType(EntityQueryObjectWrapper.class);
        private static final Signature NEW_INSTANCE = new Signature("newInstance", EntityQueryObject.access$100(), new Type[0]);
        private static final Signature PROCESS_WRAPPER = new Signature("processWrapper", TYPE_ENTITY_WRAPPER, new Type[]{TYPE_ENTITY_WRAPPER});
        private static final Map<String, Signature> OP_MAP = new HashMap<String, Signature>();
        private static final String OP_DEFAULT = "eq";
        private static final String OP_ORDER_BY = "orderby";
        private final Class<?> entityClass;
        private final Class<?> queryClass;

        protected Generator(Class<?> entityClass, Class<?> queryClass) {
            super(SOURCE);
            this.entityClass = entityClass;
            this.queryClass = queryClass;
            super.setNamePrefix(queryClass.getName());
        }

        public EntityQueryObject<T> create() {
            Object key = KEY_FACTORY.newInstance(this.entityClass, this.queryClass);
            return (EntityQueryObject)super.create(key);
        }

        public void generateClass(ClassVisitor v) throws Exception {
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(52, 1, this.getClassName(), BEAN_TYPE_SELF, null, "<generated>");
            EmitUtils.null_constructor((ClassEmitter)ce);
            this.generateNewInstance(ce);
            this.generateProcessWrapper(ce);
        }

        private void generateNewInstance(ClassEmitter ce) {
            CodeEmitter e = ce.begin_method(4, NEW_INSTANCE, null);
            e.new_instance_this();
            e.dup();
            e.invoke_constructor_this();
            e.return_value();
            e.end_method();
        }

        private void generateProcessWrapper(ClassEmitter ce) {
            PropertyDescriptor[] getters;
            Map columnMap = LambdaUtils.getColumnMap(this.entityClass);
            Type queryType = Type.getType(this.queryClass);
            CodeEmitter e = ce.begin_method(4, PROCESS_WRAPPER, null);
            Local qoLocal = e.make_local(queryType);
            e.load_this();
            e.super_getfield("queryObject", Constants.TYPE_OBJECT);
            e.checkcast(queryType);
            e.store_local(qoLocal);
            Local valueLocal = e.make_local(Constants.TYPE_OBJECT);
            e.load_arg(0);
            for (PropertyDescriptor getter : getters = ReflectUtils.getBeanGetters(this.queryClass)) {
                String pName = getter.getName();
                String op = this.getOpWord(pName);
                if (OP_MAP.containsKey(op)) {
                    pName = pName.substring(0, pName.length() - op.length());
                } else {
                    op = OP_DEFAULT;
                }
                pName = LambdaUtils.formatKey((String)pName);
                if (!columnMap.containsKey(pName)) continue;
                pName = ((ColumnCache)columnMap.get(pName)).getColumn();
                MethodInfo readMethod = ReflectUtils.getMethodInfo((Member)getter.getReadMethod());
                if (OP_ORDER_BY.equals(op)) {
                    e.load_this();
                    e.load_local(qoLocal);
                    e.invoke(readMethod);
                    e.push(pName);
                    e.invoke_virtual_this(OP_MAP.get(op));
                    continue;
                }
                Label endIf = e.make_label();
                e.load_local(qoLocal);
                e.invoke(readMethod);
                e.store_local(valueLocal);
                e.load_local(valueLocal);
                e.ifnull(endIf);
                e.push(pName);
                e.load_local(valueLocal);
                e.invoke_virtual(TYPE_ENTITY_WRAPPER, OP_MAP.get(op));
                e.checkcast(TYPE_ENTITY_WRAPPER);
                e.mark(endIf);
            }
            e.return_value();
            e.end_method();
        }

        private String getOpWord(String text) {
            char c;
            int i;
            char[] chars = text.toCharArray();
            for (i = chars.length - 1; i >= 0 && (c = chars[i]) >= 'a' && c <= 'z'; --i) {
            }
            return i <= 0 ? "" : text.substring(i).toLowerCase();
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.entityClass.getClassLoader();
        }

        protected Object firstInstance(Class aClass) throws Exception {
            return ReflectUtils.newInstance((Class)aClass);
        }

        protected Object nextInstance(Object instance) throws Exception {
            return ((EntityQueryObject)instance).newInstance();
        }

        static {
            Function<String, Signature> signatureCreater = s -> new Signature(s, Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_STRING, Constants.TYPE_OBJECT});
            OP_MAP.put(OP_DEFAULT, signatureCreater.apply(OP_DEFAULT));
            OP_MAP.put("ge", signatureCreater.apply("ge"));
            OP_MAP.put("gt", signatureCreater.apply("gt"));
            OP_MAP.put("le", signatureCreater.apply("le"));
            OP_MAP.put("lt", signatureCreater.apply("lt"));
            OP_MAP.put("ne", signatureCreater.apply("ne"));
            OP_MAP.put("like", signatureCreater.apply("like"));
            OP_MAP.put("llike", signatureCreater.apply("leftLike"));
            OP_MAP.put("rlike", signatureCreater.apply("rightLike"));
            OP_MAP.put("nlike", signatureCreater.apply("notLike"));
            OP_MAP.put(OP_ORDER_BY, new Signature("cacheOrderInfo", Type.VOID_TYPE, new Type[]{Type.INT_TYPE, Constants.TYPE_STRING}));
        }
    }

    private static class Order {
        int orderValue;
        String columnName;

        private Order() {
        }

        private int absOrderValue() {
            return Math.abs(this.orderValue);
        }
    }

    static interface EntityQueryObjectKey {
        public Object newInstance(Class<?> var1, Class<?> var2);
    }
}

