/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatis.logger;

import cn.com.yusys.yusp.commons.mybatis.logger.SqlLogger;
import cn.com.yusys.yusp.commons.mybatis.util.PluginUtils;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=StatementHandler.class, method="batch", args={Statement.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class})})
public class SqlLoggerInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        long startTime = System.currentTimeMillis();
        try {
            Object object = invocation.proceed();
            this.outSqlExecuteInfo(System.currentTimeMillis() - startTime, invocation, true);
            return object;
        }
        catch (Exception e) {
            this.outSqlExecuteInfo(System.currentTimeMillis() - startTime, invocation, false);
            throw e;
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private void outSqlExecuteInfo(long ms, Invocation invocation, boolean isSuccess) {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObjectHandler = SystemMetaObject.forObject(PluginUtils.realTarget(statementHandler));
        MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
        String sqlId = mappedStatement.getId();
        ParameterHandler parameterHandler = (ParameterHandler)metaObjectHandler.getValue("delegate.parameterHandler");
        String executeSql = this.beautifySql((String)metaObjectHandler.getValue("delegate.boundSql.sql"));
        MetaObject parameterMetaObject = SystemMetaObject.forObject((Object)parameterHandler);
        CustomizedParameterHandler customizedParameterHandler = new CustomizedParameterHandler(mappedStatement, parameterHandler.getParameterObject(), (BoundSql)parameterMetaObject.getValue("boundSql"));
        customizedParameterHandler.setParameters(null);
        if (isSuccess) {
            SqlLogger.info(ms, sqlId, executeSql, true, customizedParameterHandler.getParameters());
        } else {
            SqlLogger.error(ms, sqlId, executeSql, false, customizedParameterHandler.getParameters());
        }
    }

    private String beautifySql(String sql) {
        return StringUtils.nonEmpty((CharSequence)sql) ? sql.replaceAll("[\\s\n ]+", " ") : "";
    }

    private static class CustomizedParameterHandler
    implements ParameterHandler {
        private final TypeHandlerRegistry typeHandlerRegistry;
        private final Object parameterObject;
        private final BoundSql boundSql;
        private final Configuration configuration;
        private Object[] params;

        public CustomizedParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
            this.configuration = mappedStatement.getConfiguration();
            this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
            this.parameterObject = parameterObject;
            this.boundSql = boundSql;
        }

        public Object getParameterObject() {
            return this.parameterObject;
        }

        public Object[] getParameters() {
            return this.params;
        }

        public void setParameters(PreparedStatement ps) {
            LinkedList<Object> listParams = new LinkedList<Object>();
            List parameterMappings = this.boundSql.getParameterMappings();
            if (parameterMappings == null) {
                this.params = listParams.toArray();
                return;
            }
            for (ParameterMapping parameterMapping : parameterMappings) {
                if (ParameterMode.OUT == parameterMapping.getMode()) continue;
                listParams.add(this.paramValue(parameterMapping));
            }
            this.params = listParams.toArray();
        }

        private Object paramValue(ParameterMapping parameterMapping) {
            Object value = null;
            String propertyName = parameterMapping.getProperty();
            if (this.boundSql.hasAdditionalParameter(propertyName)) {
                value = this.boundSql.getAdditionalParameter(propertyName);
            } else if (this.parameterObject == null) {
                value = null;
            } else if (this.typeHandlerRegistry.hasTypeHandler(this.parameterObject.getClass())) {
                value = this.parameterObject;
            } else if (propertyName.startsWith("__frch")) {
                if (Map.class.isAssignableFrom(this.parameterObject.getClass())) {
                    value = this.frchMapValue(propertyName);
                }
            } else {
                MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
                if (metaObject.hasGetter(propertyName)) {
                    value = metaObject.getValue(propertyName);
                }
            }
            return value;
        }

        private Object frchMapValue(String propertyName) {
            Object value = null;
            MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
            if (metaObject.hasGetter("array")) {
                Object[] array = (Object[])metaObject.getValue("array");
                value = array[NumberUtils.toInteger((Object)propertyName.substring(propertyName.length() - 1), (Integer)0)];
            } else if (metaObject.hasGetter("list")) {
                List list = (List)metaObject.getValue("list");
                value = list.get(NumberUtils.toInteger((Object)propertyName.substring(propertyName.length() - 1), (Integer)0));
                String actualParameter = propertyName.substring(0, propertyName.lastIndexOf("_")).replace("__frch_", "");
                if (actualParameter.contains(".")) {
                    MetaObject object = this.configuration.newMetaObject(value);
                    value = object.getValue(actualParameter.substring(actualParameter.indexOf(".") + 1));
                }
            }
            return value;
        }
    }
}

