/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatis.warn;

import cn.com.yusys.yusp.commons.mybatis.warn.LargeResultHandle;
import cn.com.yusys.yusp.commons.mybatis.warn.config.WarnProperties;
import cn.com.yusys.yusp.commons.mybatis.warn.notify.ILargeResultWarn;
import java.util.ArrayList;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class LargeResultInterceptor
implements Interceptor {
    private final ILargeResultWarn warn;
    private final WarnProperties warnProperties;

    public LargeResultInterceptor(WarnProperties warnProperties, ILargeResultWarn warn) {
        this.warnProperties = warnProperties;
        this.warn = warn;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (result instanceof ArrayList) {
            long length = ((ArrayList)result).size();
            if (Boolean.TRUE.equals(LargeResultHandle.PAGE_QUERY.get())) {
                if (Boolean.TRUE.equals(this.warnProperties.getPage().getEnabled()) && length > this.warnProperties.getPage().getCount()) {
                    this.warn.notify(true, length, this.warnProperties.getPage().getCount());
                }
            } else if (Boolean.TRUE.equals(this.warnProperties.getNormal().getEnabled()) && length > this.warnProperties.getNormal().getCount()) {
                this.warn.notify(false, length, this.warnProperties.getNormal().getCount());
            }
            LargeResultHandle.clearThreadLocal();
        }
        return result;
    }
}

