/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatis.logger;

import cn.com.yusys.yusp.commons.mybatis.logger.SqlLogger;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SqlExecutorLoggerInterceptor
implements Interceptor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(SqlExecutorLoggerInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object returnValue = invocation.proceed();
            SqlExecutorLoggerInterceptor.logger(invocation, System.currentTimeMillis() - start, true);
            return returnValue;
        }
        catch (Throwable e) {
            SqlExecutorLoggerInterceptor.logger(invocation, System.currentTimeMillis() - start, false);
            throw e;
        }
    }

    private static void logger(Invocation invocation, long timeConsuming, boolean isSuccess) {
        try {
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            SqlExecutorLoggerInterceptor.sqlLogger(ms.getConfiguration(), SqlExecutorLoggerInterceptor.getBoundSql(args), ms.getId(), timeConsuming, isSuccess);
        }
        catch (Exception e) {
            logger.error("Intercept sql processing error, cause by:{}", (Object)e.getMessage());
        }
    }

    private static BoundSql getBoundSql(Object[] args) {
        return Arrays.stream(args).filter(BoundSql.class::isInstance).map(BoundSql.class::cast).findFirst().orElseGet(() -> {
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = null;
            if (args.length > 1) {
                parameter = args[1];
            }
            return ms.getBoundSql(parameter);
        });
    }

    private static void sqlLogger(Configuration configuration, BoundSql boundSql, String sqlId, long time, boolean isSuccess) {
        List<String> parameter = SqlExecutorLoggerInterceptor.parseParameters(configuration, boundSql);
        if (isSuccess) {
            SqlLogger.info(time, sqlId, SqlExecutorLoggerInterceptor.beautifySql(boundSql.getSql()), true, parameter.toArray());
        } else {
            SqlLogger.error(time, sqlId, SqlExecutorLoggerInterceptor.beautifySql(boundSql.getSql()), false, parameter.toArray());
        }
    }

    private static String beautifySql(String sql) {
        return StringUtils.nonEmpty((CharSequence)sql) ? sql.replaceAll("[\\s\\n ]+", " ") : "";
    }

    private static List<String> parseParameters(Configuration configuration, BoundSql boundSql) {
        LinkedList<String> parameters = new LinkedList<String>();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        if (!CollectionUtils.isEmpty((Collection)parameterMappings) && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                parameters.add(StringUtils.replaceObjNull((Object)parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        parameters.add(StringUtils.replaceObjNull((Object)obj));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        parameters.add(StringUtils.replaceObjNull((Object)obj));
                        continue;
                    }
                    parameters.add(null);
                }
            }
        }
        return parameters;
    }

    public Object plugin(Object arg0) {
        return Plugin.wrap((Object)arg0, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

