/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionUtils {
    private TransactionUtils() {
    }

    public static <T> T execTransRollbackWhenException(Supplier<T> task) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)SpringContextUtils.getApplicationContext().getBeanProvider(PlatformTransactionManager.class).getIfAvailable();
        return TransactionUtils.execTransRollbackWhenException(task, transactionManager);
    }

    public static void execTransRollbackWhenException(Runnable task) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)SpringContextUtils.getApplicationContext().getBeanProvider(PlatformTransactionManager.class).getIfAvailable();
        TransactionUtils.execTransRollbackWhenException(task, transactionManager);
    }

    public static <T> T execTransRollbackWhenException(Supplier<T> task, PlatformTransactionManager transactionManager) {
        if (Objects.nonNull(transactionManager)) {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(0);
            TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            try {
                T output = task.get();
                transactionManager.commit(transactionStatus);
                return output;
            }
            catch (Exception e) {
                transactionManager.rollback(transactionStatus);
                throw e;
            }
        }
        return task.get();
    }

    public static void execTransRollbackWhenException(Runnable task, PlatformTransactionManager transactionManager) {
        if (Objects.nonNull(transactionManager)) {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(0);
            TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            try {
                task.run();
                transactionManager.commit(transactionStatus);
            }
            catch (Exception e) {
                transactionManager.rollback(transactionStatus);
                throw e;
            }
        } else {
            task.run();
        }
    }
}

