/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils {
    private RequestUtils() {
    }

    public static String getRequestPath(HttpServletRequest request) {
        String contextPath;
        String path = request.getPathInfo();
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = request.getRequestURI();
        }
        if (StringUtils.nonEmpty((CharSequence)(contextPath = request.getContextPath())) && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        return StringUtils.substringStart((String)path, (String)contextPath);
    }

    public static HttpServletRequest request() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletResponse response() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return servletRequestAttributes.getResponse();
    }
}

