/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncTask;

public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    private LogUtils() {
    }

    public static void traceDebug(Logger logger, Function<Boolean, String> messageFactory) {
        if (logger.isDebugEnabled()) {
            boolean traceEnabled = logger.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                logger.trace(logMessage);
            } else {
                logger.debug(logMessage);
            }
        }
    }

    private static String formatString(String str, boolean limitLength) {
        return limitLength && str.length() > 100 ? str.substring(0, 100) + " (truncated)..." : str;
    }

    public static String parseParams(Map<String, Object> items) {
        return LogUtils.parseParams(items, ObjectMapperUtils.instance());
    }

    public static String parseParams(Map<String, Object> items, ObjectMapper mapper) {
        return LogUtils.parseParams(items, mapper, false);
    }

    public static String parseParams(Map<String, Object> items, boolean limitLength) {
        return LogUtils.parseParams(items, ObjectMapperUtils.instance(), limitLength);
    }

    public static String parseParams(Map<String, Object> items, ObjectMapper mapper, boolean limitLength) {
        if (Objects.isNull(items)) {
            return null;
        }
        StringBuilder arg = new StringBuilder("{");
        String itemString = items.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + LogUtils.parseParam(entry.getValue(), mapper)).collect(Collectors.joining(","));
        arg.append(itemString);
        arg.append("}");
        String str = arg.toString();
        return LogUtils.formatString(str, limitLength);
    }

    public static String parseParams(Object[] args) {
        return LogUtils.parseParams(args, ObjectMapperUtils.instance());
    }

    public static String parseParams(Object[] args, boolean limitLength) {
        return LogUtils.parseParams(args, ObjectMapperUtils.instance(), limitLength);
    }

    public static String parseParams(Object[] args, ObjectMapper objectMapper) {
        return LogUtils.parseParams(args, objectMapper, false);
    }

    public static String parseParams(Object[] args, ObjectMapper objectMapper, boolean limitLength) {
        StringBuilder params = new StringBuilder("[");
        if (CommonUtils.nonNullOrEmpty((Object[])args)) {
            params.append(Arrays.stream(args).map(arg -> LogUtils.parseParam(arg, objectMapper)).collect(Collectors.joining(",")));
        }
        params.append("]");
        String str = params.toString();
        return LogUtils.formatString(str, limitLength);
    }

    public static String parseParam(Object arg) {
        return LogUtils.parseParam(arg, ObjectMapperUtils.instance());
    }

    public static String parseParam(Object arg, boolean limitLength) {
        return LogUtils.parseParam(arg, ObjectMapperUtils.instance(), limitLength);
    }

    public static String parseParam(Object arg, ObjectMapper objectMapper) {
        return LogUtils.parseParam(arg, objectMapper, false);
    }

    public static String parseParam(Object arg, ObjectMapper objectMapper, boolean limitLength) {
        if (Objects.isNull(arg)) {
            return null;
        }
        if (!(arg instanceof String || arg instanceof byte[] || LogUtils.isHttpRequest(arg) || LogUtils.isAsyncReturnResult(arg) || !objectMapper.canSerialize(arg.getClass()))) {
            try {
                return objectMapper.writeValueAsString(arg);
            }
            catch (JsonProcessingException e) {
                log.warn("print object info failure. message:{}", (Object)e.getMessage());
            }
        }
        String str = StringUtils.toString((Object)arg);
        return LogUtils.formatString(str, limitLength);
    }

    private static boolean isHttpRequest(Object arg) {
        return arg instanceof HttpServletRequest || arg instanceof HttpServletResponse;
    }

    private static boolean isAsyncReturnResult(Object arg) {
        return arg instanceof DeferredResult || arg instanceof Callable || arg instanceof WebAsyncTask;
    }
}

