/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.base.message;

import cn.com.yusys.yusp.commons.base.message.MessageProcess;
import cn.com.yusys.yusp.commons.i18n.MessageUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.text.MessageFormat;
import org.springframework.beans.factory.ObjectProvider;

public class YuspMessageUtils {
    public static String getMessage(String code, String defaultMessage, String langCode, Object ... args) {
        String message = MessageUtils.getMessage((String)code, (String)defaultMessage, (String)langCode, (Object[])args);
        if (null == message) {
            message = YuspMessageUtils.getMessageByProcess(code, langCode, args);
        }
        if (null == message) {
            message = code;
        }
        return message;
    }

    public static String getMessage(String code, Object ... args) {
        String message = MessageUtils.getMessage((String)code, (Object[])args);
        if (null == message) {
            message = YuspMessageUtils.getMessageByProcess(code, null, args);
        }
        if (null == message) {
            message = code;
        }
        return message;
    }

    private static String getMessageByProcess(String code, String langCode, Object ... args) {
        ObjectProvider<MessageProcess> p = SpringContextUtils.getBeanProvider(MessageProcess.class);
        MessageProcess process = (MessageProcess)p.getIfAvailable();
        if (null != process) {
            String message = process.getMessageByCode(code, langCode, args);
            if (null != message && null != args) {
                MessageFormat messageFormat = new MessageFormat(message);
                message = messageFormat.format(args);
            }
            return message;
        }
        return null;
    }
}

