/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.start;

import cn.com.yusys.yusp.commons.module.start.AppMessages;
import cn.com.yusys.yusp.commons.module.start.AppMessagesService;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class AppMessagesPrinter {
    private static final Logger log = LoggerFactory.getLogger(AppMessagesPrinter.class);

    private AppMessagesPrinter() throws IllegalAccessException {
        throw new IllegalAccessException("Utils can not create instance!");
    }

    public static void printAppMessage(ApplicationContext context, Class<?> mainClass) {
        try {
            AppMessagesService startMessagesService = (AppMessagesService)context.getBeanProvider(AppMessagesService.class).getIfAvailable();
            if (Objects.isNull(startMessagesService)) {
                startMessagesService = new AppMessagesService.DefaultMessagesService();
            }
            AppMessages messages = startMessagesService.loadAppMessages(context);
            AppMessagesPrinter.printAppMessage(mainClass, messages.getServiceName(), messages.getProtocol(), messages.getPort(), messages.getIp(), messages.getProfiles());
        }
        catch (Exception e) {
            log.debug("print app start message failure,cause by :{}", (Object)e.getMessage());
        }
    }

    public static void printAppMessage(ApplicationContext context) {
        AppMessagesPrinter.printAppMessage(context, null);
    }

    public static void printAppMessage() {
        AppMessagesPrinter.printAppMessage(SpringContextUtils.getApplicationContext());
    }

    public static void printAppMessage(Class<?> mainClass) {
        AppMessagesPrinter.printAppMessage(SpringContextUtils.getApplicationContext(), mainClass);
    }

    private static void printAppMessage(Class<?> mainClass, String serviceName, String protocol, Integer port, String ip, String[] profiles) {
        String msg = "\n----------------------------------------------------------\n\tApplication ''{0}'' is running! Access URLs:\n\t  Local:    \t{1}://localhost:{2}\n\tExternal: \t{1}://{3}:{2}\n\tProfile(s): \t{4}\n----------------------------------------------------------\n\t";
        String printMessage = MessageFormat.format(msg, serviceName, protocol, String.valueOf(port), ip, Arrays.toString(profiles));
        AppMessagesPrinter.getLogger(mainClass).info(printMessage);
    }

    private static Logger getLogger(Class<?> mainClass) {
        if (Objects.nonNull(mainClass)) {
            return LoggerFactory.getLogger(mainClass);
        }
        StackTraceElement[] elements = Thread.getAllStackTraces().get(Thread.currentThread());
        String clazz = null;
        for (StackTraceElement element : elements) {
            if (!"main".equals(element.getMethodName())) continue;
            clazz = element.getClassName();
            break;
        }
        if (StringUtils.isEmpty(clazz)) {
            clazz = AppMessagesPrinter.class.getName();
        }
        return LoggerFactory.getLogger(clazz);
    }
}

