/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module;

import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleEvent;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHelper {
    private static final Logger log = LoggerFactory.getLogger(ModuleHelper.class);
    private static Map<String, Module> modules = new ConcurrentHashMap<String, Module>(64);
    private static final AtomicBoolean INITLIZATING = new AtomicBoolean(false);

    private ModuleHelper() {
    }

    static void register(List<Module> moduleList) {
        if (Objects.nonNull(moduleList) && INITLIZATING.compareAndSet(false, true)) {
            for (Module module : moduleList) {
                modules.put(module.getName(), module);
                log.info("The current registered components is:{}, version is:{}", (Object)module.getName(), (Object)module.getVersion());
            }
        }
    }

    static boolean hasRegister() {
        return INITLIZATING.get();
    }

    static void initRefresh() {
        for (String key : modules.keySet()) {
            SpringContextUtils.publishEvent(new ModuleEvent(key));
        }
    }

    public static List<Module> modules() {
        return Collections.unmodifiableList(new ArrayList<Module>(modules.values()));
    }

    public static Module module(String name) {
        return modules.get(name);
    }
}

