/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Objects;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.MethodMetadata;

public class BeanDefinitionUtils {
    private BeanDefinitionUtils() {
    }

    public static String className(BeanDefinition beanDefinition) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        MethodMetadata methodMetadata;
        String beanClassName = beanDefinition.getBeanClassName();
        if (StringUtils.nonEmpty((CharSequence)beanClassName)) {
            String scopeBeanClassName = BeanDefinitionUtils.getScopeBeanClass(beanDefinition);
            return StringUtils.nonEmpty((CharSequence)scopeBeanClassName) ? scopeBeanClassName : beanClassName;
        }
        if (beanDefinition instanceof AnnotatedBeanDefinition && Objects.nonNull(methodMetadata = (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata())) {
            return methodMetadata.getReturnTypeName();
        }
        return beanClassName;
    }

    private static String getScopeBeanClass(BeanDefinition definition) {
        RootBeanDefinition rootBeanDefinition;
        BeanDefinitionHolder holder;
        if (definition instanceof RootBeanDefinition && Objects.nonNull(holder = (rootBeanDefinition = (RootBeanDefinition)definition).getDecoratedDefinition()) && rootBeanDefinition.hasBeanClass() && ScopedProxyFactoryBean.class.isAssignableFrom(rootBeanDefinition.getBeanClass())) {
            return holder.getBeanDefinition().getBeanClassName();
        }
        return null;
    }

    public static boolean isAssignFrom(BeanDefinition definition, Class<?> parentClass) throws ClassNotFoundException {
        String className = BeanDefinitionUtils.className(definition);
        return StringUtils.nonEmpty((CharSequence)className) && parentClass.isAssignableFrom(Class.forName(className));
    }
}

