/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.refresh;

import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleHelper;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.Ordered;

public class ModuleRefreshScopeBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ModuleRefreshScopeBeanDefinitionRegistryPostProcessor.class);
    private static final String REFRESH_SCOPE = "refresh";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ModuleHelper.modules().forEach(module -> this.setModuleRefreshScopeSupport((Module)module, registry));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    void setModuleRefreshScopeSupport(Module module, BeanDefinitionRegistry registry) {
        String propertiesClasses = module.getProperty().getClasses();
        if (StringUtils.nonEmpty((CharSequence)propertiesClasses)) {
            String[] classTypes = StringUtils.split((String)propertiesClasses, (String)",");
            Arrays.stream(classTypes).map(StringUtils::trim).filter(StringUtils::nonEmpty).forEach(classType -> this.setModuleRefreshScopeSupport(module.getName(), (String)classType, registry));
        } else {
            logger.warn("Current module [{}] not exist need dynamic refresh class!", (Object)module.getName());
        }
    }

    void setModuleRefreshScopeSupport(String moduleName, String beanName, BeanDefinitionRegistry registry) {
        try {
            BeanDefinition definition = registry.getBeanDefinition(beanName);
            BeanDefinitionHolder holder = new BeanDefinitionHolder(definition, beanName);
            BeanDefinitionHolder proxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry, (boolean)true);
            definition.setScope(REFRESH_SCOPE);
            if (registry.containsBeanDefinition(proxy.getBeanName())) {
                registry.removeBeanDefinition(proxy.getBeanName());
            }
            registry.registerBeanDefinition(proxy.getBeanName(), proxy.getBeanDefinition());
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.warn("config module :{} need dynamic refresh bean:{} not exists. message:{}", new Object[]{moduleName, beanName, e.getMessage()});
        }
    }

    public int getOrder() {
        return 2147483542;
    }
}

