/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.log;

import cn.com.yusys.yusp.commons.module.log.DebugLoggerHelper;
import cn.com.yusys.yusp.commons.module.log.impl.SpringBootLoggerLevelRefresher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;

public class LoggerApplicationListener
implements GenericApplicationListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggerApplicationListener.class);
    private static final String MODULE_INFO_LOCATION = "module.info";
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationPreparedEvent.class};
    private static final Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class, ApplicationContext.class};
    private static final String LOGGER_REFRESHER_NAME = "loggerLevelRefresher";

    public boolean supportsEventType(ResolvableType eventType) {
        return this.isAssignableFrom(eventType.getRawClass(), EVENT_TYPES);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    private boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent((ApplicationPreparedEvent)event);
        }
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        ConfigurableListableBeanFactory beanFactory = event.getApplicationContext().getBeanFactory();
        LoggingSystem loggingSystem = (LoggingSystem)beanFactory.getBeanProvider(LoggingSystem.class).getIfAvailable();
        if (loggingSystem != null) {
            SpringBootLoggerLevelRefresher refresher = new SpringBootLoggerLevelRefresher(loggingSystem);
            DebugLoggerHelper.setRefresher(refresher);
            DebugLoggerHelper.setEnvironment((Environment)event.getApplicationContext().getEnvironment());
            DebugLoggerHelper.refreshAll();
            if (!beanFactory.containsBean(LOGGER_REFRESHER_NAME)) {
                beanFactory.registerSingleton(LOGGER_REFRESHER_NAME, (Object)refresher);
            }
        } else {
            logger.warn("Not found LoggingSystem bean, don`t refresh logger level!");
        }
    }

    public int getOrder() {
        return -2147483627;
    }
}

