/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpelUtils.class);
    private static Map<String, Expression> expressions = new ConcurrentHashMap<String, Expression>();
    public static final String SPEL_PREFIX = "#";

    private static Expression getExpression(String spelExpression) {
        if (!expressions.containsKey(spelExpression)) {
            Expression expression = null;
            SpelExpressionParser spelParser = new SpelExpressionParser();
            expression = spelExpression.startsWith(SPEL_PREFIX) ? spelParser.parseExpression(spelExpression) : spelParser.parseExpression(spelExpression, (ParserContext)new TemplateParserContext());
            expressions.put(spelExpression, expression);
        }
        return expressions.get(spelExpression);
    }

    public static String generateValueBySpel(String spelExpression, Method method, Object[] args) {
        Expression expression = SpelUtils.getExpression(spelExpression);
        String value = null;
        if (args == null || args.length == 0) {
            value = (String)expression.getValue(String.class);
        } else {
            DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
            String[] paramNames = nameDiscoverer.getParameterNames(method);
            StandardEvaluationContext context = new StandardEvaluationContext();
            for (int i = 0; i < args.length; ++i) {
                context.setVariable(paramNames[i], args[i]);
            }
            value = (String)expression.getValue((EvaluationContext)context, String.class);
        }
        logger.debug("Currently resolved spel expression is:{}, execution result is:{}", (Object)spelExpression, (Object)value);
        return value;
    }
}

