/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.BufferedInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);
    private static final Pattern JDBC_DIALECT_PATTERN = Pattern.compile(":(.*?):");
    private static final Pattern TABLE_NAME = Pattern.compile("\\$\\{tableName\\}");

    public static void createTable(JdbcTemplate jdbcTemplate, String createScriptPrefix, String tableName) throws Exception {
        DataSourceUtils.createTable(jdbcTemplate.getDataSource(), createScriptPrefix, tableName);
    }

    public static void createTable(DataSource dataSource, String createScriptPrefix, String tableName) throws Exception {
        String createScript = StringUtils.builder0((Object[])new Object[]{createScriptPrefix, DataSourceUtils.dialect(dataSource), ".sql"});
        Connection conn = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(DataSourceUtils.class.getClassLoader().getResourceAsStream(createScript));){
            byte[] bytes = new byte[bufferedInputStream.available()];
            int len = bufferedInputStream.read(bytes);
            if (len < 0) {
                logger.warn("Table name[{}], script prefix[{}] read text file len lt zero!", (Object)tableName, (Object)createScriptPrefix);
            }
            String createSql = new String(bytes, StandardCharsets.UTF_8);
            conn = dataSource.getConnection();
            try (Statement statement = conn.createStatement();){
                statement.executeUpdate(DataSourceUtils.replaceTableName(createSql, tableName));
                logger.info("Initialization database success!");
            }
        }
        catch (Exception e) {
            try {
                logger.error("Initialization execution failed!", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(conn)) {
                    org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection(conn, (DataSource)dataSource);
                }
                throw throwable;
            }
        }
        if (Objects.nonNull(conn)) {
            org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
        }
    }

    public static void createTable(String createScriptPrefix, String tableName) throws Exception {
        JdbcTemplate jdbcTemplate = SpringContextUtils.getBean(JdbcTemplate.class);
        DataSourceUtils.createTable(jdbcTemplate, createScriptPrefix, tableName);
    }

    public static boolean executeUpdateScript(DataSource dataSource, String script) throws Exception {
        return DataSourceUtils.executeUpdateScript(dataSource, script, true);
    }

    /*
     * Exception decompiling
     */
    public static boolean executeUpdateScript(DataSource dataSource, String script, boolean isRelease) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String dialect(DataSource dataSource) {
        Matcher matcher = JDBC_DIALECT_PATTERN.matcher(DataSourceUtils.getUrl(dataSource));
        return matcher.find() ? matcher.group(1) : null;
    }

    public static String getUrl(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = org.springframework.jdbc.datasource.DataSourceUtils.getConnection((DataSource)dataSource);
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    public static String dialect(Connection connection, boolean isClose) {
        try {
            Matcher matcher = JDBC_DIALECT_PATTERN.matcher(connection.getMetaData().getURL());
            String string = matcher.find() ? matcher.group(1) : null;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (isClose) {
                org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection((Connection)connection, null);
            }
        }
    }

    private static String replaceTableName(String str, String tableName) {
        Matcher matcher = TABLE_NAME.matcher(str);
        return matcher.find() ? matcher.replaceAll(tableName) : str;
    }

    public static int executeQueryScript(DataSource dataSource, String script) throws Exception {
        return DataSourceUtils.executeQueryScript(dataSource, script, true);
    }

    /*
     * Exception decompiling
     */
    public static int executeQueryScript(DataSource dataSource, String script, boolean isRelease) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

